/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-10 18:05:21
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-09-01 14:09:28
 * @FilePath: /bkunyun/src/views/ConsoleLayout/components/TransferList/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { Box } from "@mui/material";
import { memo } from "react";

import MySelect from "@/components/mui/MySelect";
import MyTitle from "@/components/mui/MyTitle";
import FileItem from "../FileItem";
import useGlobalStore from "@/hooks/useGlobalStore";
import { observer } from "mobx-react-lite";
import { toJS } from "mobx";

const TranSferList = observer(() => {
	const uploadInfoStore = toJS(useGlobalStore("fileListStore"));

	return (
		<Box style={{ width: 520, padding: 20 }}>
			<MyTitle title="传输列表" />
			<Box
				style={{
					display: "flex",
					justifyContent: "space-between",
					alignItems: "center",
				}}
			>
				<Box style={{ color: "#8A9099" }}>请勿在上传过程中刷新页面！</Box>
				<MySelect
					variant="standard"
					value={"default"}
					onChange={() => console.log(11)}
					options={[
						{
							label: "默认线路",
							value: "default",
						},
					]}
					size="small"
				/>
			</Box>
			<div style={{ height: 400, overflow: "overlay" }}>
				{uploadInfoStore?.fileList.map((item) => {
					return <FileItem fileItemInfo={item} key={item.id} />;
				})}
			</div>
		</Box>
	);
});

export default memo(TranSferList);
