/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-01 16:53:15
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-25 12:04:49
 * @FilePath: /bkunyun/src/components/Material.Ui/Table/EnhancedTableHead.jsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import TableHead from "@mui/material/TableHead";
import TableSortLabel from "@mui/material/TableSortLabel";
import TableRow from "@mui/material/TableRow";
import TableCell from "@mui/material/TableCell";
import Checkbox from "@mui/material/Checkbox";
import Typography from "@mui/material/Typography";
import Tooltip from '@mui/material/Tooltip';
import ErrorOutlineIcon from '@mui/icons-material/ErrorOutline';

const EnhancedTableHead = (props: any) => {
    const { classes, onSelectAllClick, order, orderBy, TableHeadClasses, numSelected, rowCount, onRequestSort, headCells, headTableCell, headTableCellCheckbox, RowStyle, headTableCellStyle } = props;
    const createSortHandler = (property: any) => (event: any) => {
        onRequestSort(event, property);
    };
    return (
        <TableHead classes={{ root: TableHeadClasses || classes.TableHeadClasses }} sx={{
            th: {
                backgroundColor: '#F7F8FA',
            }
        }}>
            <TableRow style={{ ...RowStyle }}>
                {
                    headCells.filter((k: any) => k.id === "checkbox").length > 0 && <TableCell sx={{
                        border: 'none'
                    }} padding="checkbox">
                        <Checkbox
                            sx={{ color: '#D1D6DE' }}
                            color={'primary'}
                            indeterminate={numSelected > 0 && numSelected < rowCount}
                            checked={rowCount > 0 && numSelected === rowCount}
                            onChange={onSelectAllClick}
                            inputProps={{ "aria-label": "select all desserts" }}
                        />
                    </TableCell>
                }
                {headCells.map((headCell: any, k: any) => (
                    <TableCell
                        sx={{
                            border: 'none',
                            ...headTableCellStyle
                        }}
                        key={headCell.id}
                        style={{ width: headCell.width ? headCell.width : "", textAlign: headCell.numeric ? "right" : "left", display: headCell.id !== "checkbox" ? "" : "none" }}
                        padding={headCell.disablePadding ? "none" : "normal"}
                        sortDirection={orderBy === headCell.id ? order : false}
                        classes={{ head: (k && headTableCell) || classes.headTableCell }}
                    >
                        {
                            headCell.sort && <TableSortLabel active={orderBy === headCell.id} direction={order} onClick={createSortHandler(headCell.id)} >
                                {headCell.label}
                            </TableSortLabel>
                        }
                        {
                            !headCell.sort && <Typography className={headTableCellCheckbox || ''} style={headCell.tooltip ? { display: "flex", alignItems: "center" } : {}}      >
                                {headCell.label}
                                {headCell.tooltip ? <Tooltip title={headCell.tooltip} placement="top" arrow>
                                    <ErrorOutlineIcon style={{ fontSize: "16px", marginLeft: "5px" }} fontSize="small" />
                                </Tooltip> : ""}
                            </Typography>
                        }
                    </TableCell>
                ))}
            </TableRow>
        </TableHead>
    );
}


export default EnhancedTableHead