import React from "react";

import {
  Button,
  Dialog,
  DialogActions,
  DialogContent,
  DialogTitle,
} from "@mui/material";
import CloseIcon from "@mui/icons-material/Close";

export interface IDialogProps {
  /** 自定义类名 */
  className?: string;
  /** 自定义样式 */
  style?: React.CSSProperties;
  /** 弹窗的标题 */
  title?: string;
  /** 是否显示弹窗 */
  open: boolean;
  isHideHeader?: boolean;
  /** 是否隐藏弹窗底部按钮部分 */
  isHideFooter?: boolean;
  /** 自定义底部按钮 */
  footerRender?: () => React.ReactNode;
  /** 是否显示取消按钮 */
  showCancel?: boolean;
  /** 是否显示确定按钮 */
  showConfirm?: boolean;
  /** 关闭弹窗时的回调函数 */
  onClose?: () => void;
  /** 点击确定按钮时的回调函数 */
  onConfirm?: () => void;
  /** 取消按钮文案 */
  cancelText?: string;
  /** 确认按钮文案 */
  okText?: string;
  /** 是否禁用确认按钮 */
  disabledConfirm?: boolean;
  children: React.ReactNode;
}

export interface IFooter {
  isHideFooter?: boolean;
  footerRender?: () => React.ReactNode;
  showCancel?: boolean;
  /** 是否显示确定按钮 */
  showConfirm?: boolean;
  /** 关闭弹窗时的回调函数 */
  onClose?: () => void;
  /** 点击确定按钮时的回调函数 */
  onConfirm?: () => void;
  /** 取消按钮文案 */
  cancelText?: string;
  /** 确认按钮文案 */
  okText?: string;
  /** 是否禁用确认按钮 */
  disabledConfirm?: boolean;
}

const MyDialog: React.FunctionComponent<IDialogProps> = (props) => {
  const {
    title,
    open,
    style,
    onClose,
    onConfirm,
    isHideFooter,
    isHideHeader,
    children,
    footerRender,
    className,
    showCancel = true,
    /** 是否显示确定按钮 */
    showConfirm = true,
    cancelText,
    okText,
    disabledConfirm,
  } = props;
  const Footer = () => {
    if (isHideFooter) return null;
    return footerRender ? (
      footerRender()
    ) : (
      <DialogActions style={{ padding: "0 24px 24px 24px" }}>
        {showCancel ? (
          <Button onClick={onClose} variant="outlined" size="small">
            {cancelText || "取消"}
          </Button>
        ) : null}
        {showConfirm ? (
          <Button
            onClick={onConfirm}
            variant="contained"
            size="small"
            disabled={disabledConfirm}
          >
            {okText || "确定"}
          </Button>
        ) : null}
      </DialogActions>
    );
  };
  return (
    <Dialog
      open={open}
      onClose={onClose}
      style={style}
      className={className}
      aria-labelledby="alert-dialog-title"
      aria-describedby="alert-dialog-description"
    >
      {isHideHeader ? null : (
        <DialogTitle id="alert-dialog-title">
          <div
            style={{
              display: "flex",
              justifyContent: "space-between",
              alignItems: "center",
            }}
          >
            <span>{title}</span>
            <CloseIcon
              onClick={onClose}
              style={{ color: "#C2C6CC", cursor: "pointer" }}
            />
          </div>
        </DialogTitle>
      )}
      <DialogContent style={{ minWidth: 400 }}>{children}</DialogContent>
      {Footer()}
    </Dialog>
  );
};

export default MyDialog;
