import axios from "axios";
import getHeader from "./header";
import qs from "qs";

const service = axios.create({
  // baseURL: "/api",
  timeout: 60000,
});

// 添加请求拦截器
service.interceptors.request.use(
  function (config) {
    // 在发送请求之前做些什么
    config.headers = getHeader(config.headers);
    if (
      config.headers["Content-Type"] === "application/x-www-form-urlencoded"
    ) {
      config.data = qs.stringify(config.data);
    }
    return config;
  },
  function (error) {
    // 对请求错误做些什么
    return Promise.reject(error);
  }
);

// 添加响应拦截器
service.interceptors.response.use(
  function (response) {
    // 对响应数据做点什么
    if (response.config.responseType === "blob") {
      if (response.status === 200) {
        return response;
      } else {
        return Promise.reject(response);
      }
    } else {
      if (response.status === 200) {
        return response.data;
      } else {
        return Promise.reject(response.data);
      }
    }
  },
  function (error) {
    // 对响应错误做点什么
    return Promise.reject(error.response?.data || error.message);
  }
);

export default service;
