import React, { useState, useCallback, useEffect } from "react";

import style from "./index.module.css";
import classnames from "classnames";
import { Button, InputBase, IconButton, TextField } from "@mui/material";
import { createTheme, ThemeProvider } from "@mui/material/styles";
import SearchIcon from "@mui/icons-material/Search";
import RefreshIcon from "@mui/icons-material/Refresh";
import Table from "@/components/Material.Ui/Table";
import bigFolderIcon from "@/assets/project/bigFolderIcon.svg";
import dataSetIcon from "@/assets/project/dataSetIcon.svg";
import fileIcon from "@/assets/project/fileIcon.svg";
import folderIcon from "@/assets/project/folderIcon.svg";
import noFile from "@/assets/project/noFile.svg";
import MyDialog from "@/components/mui/MyDialog";
import { useMessage } from "@/components/MySnackbar";
import { getDataFileToken } from "@/api/project_api";
import AddFolder from "./AddFolder";
import UpLoaderFile from "./UpLoaderFile";
import useMyRequest from "@/hooks/useMyRequest";
import { observer } from "mobx-react-lite";
import { useStores } from "@/store";
import CloudEController from "@/api/fileserver/CloudEController";

const theme = createTheme({
  palette: {
    neutral: {
      main: "#1370FF",
      contrastText: "#fff",
    },
  },
});
declare module "@mui/material/styles" {
  interface Palette {
    neutral: Palette["primary"];
  }

  // allow configuration using `createTheme`
  interface PaletteOptions {
    neutral?: PaletteOptions["primary"];
  }
}

// Update the Button's color prop options
declare module "@mui/material/Button" {
  interface ButtonPropsColorOverrides {
    neutral: true;
  }
}

const ProjectData = observer(() => {
  const { currentProjectStore } = useStores();
  // const [path, setPath] = useState("/ProjectData");
  const [path, setPath] = useState("/");
  const [activeTab, setActiveTab] = useState(1);
  const [keyWord, setKeyWord] = useState("");
  const [fileToken, setFileToken] = useState("");

  const { run: getDataFileTokenRun } = useMyRequest(getDataFileToken, {
    onSuccess: (res: any) => {
      console.log("res", res);
      setFileToken(res.data);
    },
  });

  useEffect(() => {
    if (fileToken) {
      CloudEController.JobOutFileList(path, false, fileToken);
      // 老项目测试环境
      // https://fileserver.cloudam.cn/list/?username=6c8928fa719940dc964cf17a029b36c5&token=d1b07aa2-0b29-48ca-ad28-bb41af3bcbb1&filetoken=%2FMm%2BLhFrOpEDp0neVeESSD%2F45aY%3D&share=false&showhidden=false
      // 新项目本地
      // https://fileserver.cloudam.cn/list/?username=8e12a4fdde5549b0aa8b3051ff8c8f04&token=751cd163-fe95-45d0-8f7a-3d0d8b8bb442&filetoken=isZw%2B%2BzeJO3R34BEXTjmmovFOmA%3D&share=false&showhidden=false
      // 老项目本地
      // https://fileserver.cloudam.cn/list/?username=6c8928fa719940dc964cf17a029b36c5&token=d1b07aa2-0b29-48ca-ad28-bb41af3bcbb1&filetoken=bUt%2Bn0YacgepFClLR4LNR0MxW0w%3D&share=false&showhidden=false
    }
  }, [fileToken, path]);

  useEffect(() => {
    getDataFileTokenRun({
      id: currentProjectStore.currentProjectInfo.id as string,
    });
  }, [getDataFileTokenRun, currentProjectStore]);

  const handleKeyWordChange = (e: any) => {
    setKeyWord(e.target.value);
  };

  const [selectIds, setSelectIds] = useState([]);

  const [list, setList] = useState([
    {
      id: 123,
      name: "name",
      type: "directory",
      mtime: new Date().getTime(),
    },
    {
      id: 9999,
      name: "name2",
      type: "file",
      size: 6,
      mtime: new Date().getTime(),
    },
  ]);

  const versionsHeadCells = [
    { id: "checkbox" },
    { id: "name", numeric: false, label: "名称", width: "25%" },
    { id: "size", numeric: false, label: "大小", width: "25%" },
    { id: "mtime", numeric: false, label: "创建时间", width: "25%" },
    { id: "caozuo", numeric: false, label: "操作", width: "25%" },
  ];

  const hanldeCheckbox = (e: any) => {
    console.log(e);
    setSelectIds(e);
  };

  const renderName = (item: any) => {
    if (item.type === "directory") {
      return (
        <span className={style.folderIconBox}>
          <img className={style.folderIcon} src={folderIcon} alt="" />
          {item.name}
        </span>
      );
    } else {
      return (
        <span className={style.folderIconBox}>
          <img className={style.folderIcon} src={fileIcon} alt="" />
          {item.name}
        </span>
      );
    }
  };

  const renderSize = (item: any) => {
    return <span>{item.size ? `${item.size}b` : "-"}</span>;
  };

  const renderMtime = (item: any) => {
    return <span>{item.mtime}</span>;
  };

  const renderButtons = (item: any) => {
    return (
      <span>
        <Button
          sx={{ position: "relative", left: "-18px" }}
          variant="text"
          size="small"
        >
          下载
        </Button>
        <Button
          sx={{ position: "relative", left: "-18px" }}
          variant="text"
          size="small"
        >
          移动至
        </Button>
        <Button
          sx={{ position: "relative", left: "-18px" }}
          variant="text"
          size="small"
          color="error"
        >
          删除
        </Button>
      </span>
    );
  };

  let UpLoaderFileRef: any = React.createRef();
  const hanleShowUpLoaderFileDialog = () => {
    UpLoaderFileRef.current.showDialog();
  };

  let addFolderRef: any = React.createRef();

  const hanleShowAddFolderDialog = () => {
    addFolderRef.current.showDialog();
  };

  return (
    <ThemeProvider theme={theme}>
      <div className={style.projectData}>
        <div className={style.projectDataStickyTop}>
          <div className={style.projectDataTitle}>项目数据</div>
          <div className={style.projectDataHeader}>
            <div className={style.projectDataButtonAndSearch}>
              <div className={style.projectDataButtonBox}>
                <Button
                  color="neutral"
                  variant="contained"
                  size="small"
                  style={{ marginRight: "12px" }}
                  onClick={hanleShowUpLoaderFileDialog}
                >
                  上传文件
                </Button>
                <Button
                  color="neutral"
                  variant="outlined"
                  size="small"
                  onClick={hanleShowAddFolderDialog}
                >
                  新建文件夹
                </Button>
              </div>
              <div className={style.projectDataSearch}>
                <InputBase
                  className={style.searchInput}
                  placeholder="输入关键词搜索"
                  inputProps={{ "aria-label": "输入关键词搜索" }}
                  value={keyWord}
                  onChange={handleKeyWordChange}
                  style={{ width: "280px", fontSize: "14px" }}
                />
                <IconButton
                  type="submit"
                  className={style.searchButton}
                  aria-label="search"
                  size="small"
                  style={{ padding: "4px" }}
                >
                  <SearchIcon
                    className={style.searchIcon}
                    style={{ color: "#999" }}
                  />
                </IconButton>
              </div>
            </div>
            <div className={style.projectDataPathAndTabs}>
              <div className={style.projectDataPath}>{path}</div>
              <div className={style.projectDataTabsAndBtton}>
                <div className={style.projectDataTabs}>
                  <div
                    className={classnames({
                      [style.projectDataTab]: true,
                      [style.projectDataTabActive]: activeTab === 1,
                    })}
                    onClick={() => setActiveTab(1)}
                  >
                    文件
                  </div>
                  <div
                    className={classnames({
                      [style.projectDataTab]: true,
                      [style.projectDataTabActive]: activeTab !== 1,
                    })}
                    onClick={() => setActiveTab(2)}
                  >
                    数据集
                  </div>
                </div>
                <IconButton aria-label="refreshIcon" size="small">
                  <RefreshIcon />
                </IconButton>
              </div>
            </div>
          </div>
          <Table
            checkboxData={(e: any) => {
              hanldeCheckbox(e);
            }}
            rowHover={true}
            stickyheader={true}
            rows={list.map((item) => ({
              ...item,
              name: renderName(item),
              size: renderSize(item),
              mtime: renderMtime(item),
              caozuo: renderButtons(item),
            }))}
            // load={loadding}
            rowsPerPage={"99"}
            headCells={versionsHeadCells}
            nopadding={true}
            footer={false}
          ></Table>
        </div>
        {selectIds.length > 0 && (
          <div className={style.projectDataStickyBox}>
            <Button
              color="error"
              variant="outlined"
              size="small"
              style={{ marginRight: "12px" }}
            >
              批量删除（{selectIds.length}）
            </Button>
            <Button
              color="neutral"
              variant="contained"
              size="small"
              style={{ marginRight: "24px" }}
            >
              批量移动（{selectIds.length}）
            </Button>
          </div>
        )}
        <UpLoaderFile
          onRef={UpLoaderFileRef}
          path={path}
          list={list}
        ></UpLoaderFile>
        <AddFolder onRef={addFolderRef} list={list}></AddFolder>
      </div>
    </ThemeProvider>
  );
});

export default ProjectData;
