import { makeAutoObservable } from "mobx";
type projectInfo = {
  id?: string;
  name?: string;
  desc?: string;
};

type productInfo = {
  id?: string;
  name?: string;
};
class currentProject {
  constructor() {
    makeAutoObservable(this);
  }

  // 选中的项目
  currentProjectInfo: projectInfo = {};
  // 选中的产品下的项目列表
  projectList: Array<projectInfo> = [];
  // 选中的产品
  currentProductInfo: productInfo = {};
  setProjectList = (list: Array<projectInfo>) => {
    this.projectList = list;
  };
  changeProject = (project: projectInfo) => {
    this.currentProjectInfo = project;
  };
}

const currentProjectStore = new currentProject();

export default currentProjectStore;
