import { useMemo } from "react";
import NglView from "@/components/BusinessComponents/NglView";
import KekuleView from "@/components/BusinessComponents/KekuleView";
import MyTooltip from "@/components/mui/MyTooltip";
import Checkbox from "@mui/material/Checkbox";
import style from "./index.module.css";
import classNames from "classnames";
import MyCircularProgress from "@/components/mui/MyCircularProgress";
import NoData from "@/components/BusinessComponents/NoData";

type IDatasetCardTableProps = {
	list: Array<any>;
	graphicDimension: string;
	showData: Array<string>;
	selectItems: Array<string>;
	setSelectItems: any;
	loading: boolean;
};

const DatasetCardTable = (props: IDatasetCardTableProps) => {
	const {
		list,
		graphicDimension,
		showData,
		selectItems,
		setSelectItems,
		loading,
	} = props;

	// 选择/取消分子
	const handleSelectItem = (id: string) => {
		let list: string[] = [...selectItems];
		if (selectItems.filter((e) => e === id).length > 0) {
			list = list.filter((e) => e !== id);
			setSelectItems(list);
		} else {
			list.push(id);
			setSelectItems(list);
		}
	};

	// 空盒子用于布局
	const nullBox = useMemo(() => {
		if (list.length > 4) {
			let nullBoxLength = Math.abs(8 - list.length);
			return new Array(nullBoxLength).fill("");
		} else {
			return [];
		}
	}, [list]);

	return (
		<>
			{list.length !== 0 && (
				<>
					<div className={style.list}>
						<MyCircularProgress loading={loading} />
						{list.map((item, index) => {
							return (
								<div
									className={style.datasetLi}
									key={item.id}
									onClick={() => {
										handleSelectItem(item.id);
									}}
								>
									<div className={style.datasetLiTop}>
										{graphicDimension === "2D" && (
											<KekuleView id={`${index}2d`} smi={item.smiles} />
										)}
										{graphicDimension === "3D" && (
											<NglView id={`${index}3d`} content={item.pdb} />
										)}
									</div>
									<div className={style.datasetLiBottom}>
										<div className={style.datasetLiTitle} title={item.smiles}>
											{item.smiles}
										</div>
										{showData.length !== 0 && (
											<div className={style.datasetLiDataList}>
												{Object.keys(item)
													.filter((key) => showData.indexOf(key) !== -1)
													.map((key, index) => {
														return (
															<div
																className={style.datasetLiDataLi}
																key={index}
															>
																<span className={style.datasetLiDataLiKey}>
																	{key}
																</span>
																<MyTooltip title={item[key]}>
																	<span className={style.datasetLiDataLiValue}>
																		{item[key]}
																	</span>
																</MyTooltip>
															</div>
														);
													})}
											</div>
										)}
										{showData.length === 0 && (
											<div className={style.noDataList}>请选择显示数据</div>
										)}
									</div>
									{graphicDimension === "2D" && (
										<Checkbox
											size="small"
											sx={{
												padding: "0px",
												position: "absolute",
												top: "16px",
												right: "20px",
												zIndex: 1,
											}}
											checked={selectItems.includes(item.id)}
										/>
									)}
									{graphicDimension === "3D" && (
										<Checkbox
											size="small"
											sx={{
												padding: "0px",
												position: "absolute",
												top: "16px",
												right: "20px",
												zIndex: 1,
												background: "RGBA(30, 38, 51, 1)",
												border: "1px solid #565C66",
												borderRadius: "2px",
											}}
											checked={selectItems.includes(item.id)}
										/>
									)}
								</div>
							);
						})}
						{nullBox.map((item, index) => {
							return (
								<div
									className={classNames({
										[style.datasetLi]: true,
										[style.nullBox]: true,
									})}
									key={index + "null"}
								></div>
							);
						})}
					</div>
				</>
			)}
			{list.length === 0 && <NoData text="未搜索到相关数据"></NoData>}
		</>
	);
};

export default DatasetCardTable;
