import { useMemo } from "react";
import MyTable from "@/components/mui/MyTableNew";
import { sortState } from "@/components/mui/MyTableNew";

type IDatasetTableProps = {
	list: Array<any>;
	showData: Array<string>;
	selectItems: Array<any>;
	setSelectItems: any;
	sortState: sortState;
	setSortState: any;
	loading: boolean;
};

const DatasetTable = (props: IDatasetTableProps) => {
	const {
		list,
		showData,
		selectItems,
		setSelectItems,
		sortState,
		setSortState,
		loading,
	} = props;
	const headCells = useMemo(() => {
		let width =
			showData.length === 0
				? window.innerWidth - 112
				: `${(window.innerWidth - 112) / showData.length}`;
		return showData.map((item, index) => {
			return {
				id: item,
				label: item,
				width,
				showOverflowTooltip: true,
				sort: true,
			};
		});
	}, [showData]);
	return (
		<MyTable
			rows={list}
			headCells={headCells}
			hasCheckbox={true}
			fixedHead={true}
			selectItems={selectItems}
			setSelectItems={setSelectItems}
			sortState={sortState}
			setSortState={setSortState}
			loading={loading}
		></MyTable>
	);
};

export default DatasetTable;
