/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-08-02 11:43:28
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-03 14:07:23
 * @FilePath: /bkunyun/src/components/BusinessComponents/SearchInput/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import OutlinedInput, { OutlinedInputProps } from "@mui/material/OutlinedInput";
import { ThemeProvider, createTheme } from "@mui/material/styles";
import SearchIcon from "@mui/icons-material/Search";

// 使用该搜索框组件时，width、height、font-size等样式属性可以在组件sx属性中覆盖掉当前组件内的样式
// 该组件默认搜索框高度为32px，宽度和容器一致，字体大小14px
// 若想自定义修改，写法：<SearchInput sx={{ width: 340 ,height: 36 ,fontSize: 12}} />

interface SearchInputProps extends OutlinedInputProps {
    value?: any;
    variant?: "standard" | "filled" | "outlined";
    size?: "small" | "medium";
    placeholder?: string;
    fullWidth?: boolean; // 宽度是否和容器一致
    error?: boolean;
};
const SearchInput = (props: SearchInputProps) => {
    const {
        size = "small",
        placeholder = "输入关键词按回车搜索",
        fullWidth = true,
        ...other
    } = props;

    const theme = createTheme({
        components: {
            MuiOutlinedInput: {
                styleOverrides: {
                    root: {
                        height: "32px",
                        fontSize: "14px",
                        paddingRight: "8px",
                        "&.Mui-focused .MuiOutlinedInput-notchedOutline": {
							borderWidth: "1px",
						},
                        "& .MuiOutlinedInput-notchedOutline": {
							borderColor: '#DDE1E6',
						},
                        ":hover": {
                            "& .MuiOutlinedInput-notchedOutline": {
                                borderColor: "#1370ff",
                            },
                        },
                    },
                    input: {
                        padding: "5px 12px",
                        verticalAlign: "middle",
                    },
                },
            },
        },
    });

    return (
        <ThemeProvider theme={theme}>
            <OutlinedInput
                size={size}
                placeholder={placeholder}
                fullWidth={fullWidth}
                endAdornment={<SearchIcon style={{ color: "#8A9099", fontSize: "22px" }} />}
                {...other}
            />
        </ThemeProvider>
    );
}

export default SearchInput