import { Box } from "@mui/material";

/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-11 11:35:22
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-11 15:10:56
 * @FilePath: /bkunyun/src/components/mui/MyTitle.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
interface IProps {
  /** 标题 */
  title: string;
  /** 自定义类名 */
  className?: string;
  /** 自定义样式 */
  style?: React.CSSProperties;
}
const MyTitle = (props: IProps) => {
  const { title } = props;
  return (
    <Box
      style={{
        padding: 12,
      }}
      {...props}
    >
      <span
        style={{
          display: "inline-block",
          color: "#1E2633",
          fontSize: 16,
          fontWeight: 600,
          padding: "0px 2px 8px 2px",
          borderBottom: "3px solid #1370FF",
        }}
      >
        {title}
      </span>
    </Box>
  );
};

export default MyTitle;
