/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-07-11 11:49:55
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-23 16:46:45
 * @FilePath: /bkunyun/src/store/modules/currentProject.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { makeAutoObservable } from "mobx";
type projectInfo = {
  id?: string;
  name?: string;
  desc?: string;
  projectRole?: string;
  filetoken?: string;
};

type productInfo = {
  id?: string;
  name?: string;
  path?: string;
};

/** 用户信息 */
let userInfo: any;
try {
  userInfo = JSON.parse(localStorage.getItem("userInfo") || "{}");
} catch {
  console.error("获取用户信息 出错");
}

const localStorageCurrentProjectInfo = JSON.parse(
  localStorage.getItem(`currentProjectInfo_${userInfo.name}`) || "{}"
);
const localStorageCurrentProductInfo = JSON.parse(
  localStorage.getItem(`currentProductInfo_${userInfo.name}`) || "{}"
);
const localStorageProjectList = JSON.parse(
  localStorage.getItem(`projectList_${userInfo.name}`) || "[]"
);

class currentProject {
  constructor() {
    makeAutoObservable(this);
  }

  // 选中的项目
  currentProjectInfo: projectInfo = localStorageCurrentProjectInfo;
  // 选中的产品下的项目列表
  projectList: Array<projectInfo> = localStorageProjectList;
  // 选中的产品
  currentProductInfo: productInfo = localStorageCurrentProductInfo;
  setProjectList = (list: Array<projectInfo>) => {
    this.projectList = list;
    localStorage.setItem(`projectList_${userInfo.name}`, JSON.stringify(list));
  };
  changeProject = (project: projectInfo) => {
    this.currentProjectInfo = project;
    localStorage.setItem(`currentProjectInfo_${userInfo.name}`, JSON.stringify(project));
  };
  changeProductInfo = (productInfo: productInfo) => {
    this.currentProductInfo = productInfo;
    localStorage.setItem(`currentProductInfo_${userInfo.name}`, JSON.stringify(productInfo));
  };
}

const currentProjectStore = new currentProject();

export default currentProjectStore;
