/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-19 17:09:23
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-25 20:26:42
 * @FilePath: /bkunyun/src/api/resourceCenter.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import request from "@/utils/axios/service";
import Api from "./api_manager";

type addActorenvBuildenvParams = {
  title: string,
  desc: string,
  baseEnvId: string,
  type: "BATCH" | "FLOW",
  filePaths: Array<string>,
  bashScript: string,
  computeType: string,
  publicProjectId: string,
}

/** 获取算子列表请求参数 */
export interface IOperatorListParams {
	keyword: string;
	productId: string;
	type: string;
}

// 获取公共项目
const getPublicProject = () => {
  return request({
    url: Api.API_GET_PUBLIC_PROJECT,
    method: "get",
  });
}

// 获取公共环境
const getPublicEnv = (params: {taskType: 'BATCH' | 'FLOW'}) => {
  return request({
    url: Api.API_GET_PUBLIC_ENV,
    method: "get",
    params,
  });
};

// 新增应用环境
const addActorenvBuildenv = (params: addActorenvBuildenvParams) => {
  return request({
    url: Api.API_ACTORENV_BUILDENV,
    method: "post",
    data: params,
  });
};

// 获取公共环境
const getActorenvList = (params: {
  type?: 'BATCH' | 'FLOW' | '',
  page: number,
  size: number,
  title?: string,
  order?: string,
}) => {
  return request({
    url: Api.API_ACTORENV_LIST,
    method: "get",
    params,
  });
};

// 删除用户算子环境
const deleteActorenv = (params: {id: string}) => {
  return request({
    url:`${Api.API_ACTORENV_DELETE}/${params.id}`,
    method: "delete",
  });
};

// 获取算子列表
const getOperatorList = (params: IOperatorListParams) => {
  return request({
    url: Api.API_OPERATOR_LIST,
    method: "get",
    params
  });
}


// 查询应用环境的详情信息
const getActorenvDetail = (params: {id: string}) => {
  return request({
    url:`${Api.API_ACTORENV_DETAIL}/${params.id}`,
    method: "get",
  });
};

// 查询应用环境的详情信息
const getActorEnvOptions = (params: {type: string}) => {
  return request({
    url: `${Api.API_ACTOR_ENV_OPTIONS}`,
    method: "get",
    params
  });
};

// 获取工作流模板
const getWorkflowspecList = (params: {productId?: string, title?: string}) => {
  return request({
    // url:`${Api.API_WORKFLOWSPEC_LIST}/${params.productId}`,
    url:`${Api.API_WORKFLOWSPEC_LIST}`,
    method: "get",
    params
  });
};
// API_WORKFLOWSPEC_LIST

// 新增应用环境
const saveOperator = (params: any, isEdit: boolean) => {
  return request({
    url: `${Api.API_SAVE_OPERATOR}?isEdit=${isEdit}`,
    method: "post",
    data: params,
  });
};

// 删除工作流模板
const deleteWorkflowspec = (params: {
  id: string
}) => {
  return request({
    url:`${Api.API_WORKFLOWSPEC_DELETE}`,
    method: "delete",
    params
  });
};

// 查询算子的详情信息
const getOperatorDetail = (id: string) => {
  return request({
    url:`${Api.API_OPERATOR_DETAILS}/${id}`,
    method: "get",
  });
};



// 获取工作流模板详情
const getWorkflowspecDetail = (id: string) => {
  return request({
    url: Api.API_WORKFLOWSPEC_DETAIL + '/' + id,
    method: "get",
  });
};


export {
  getPublicEnv,
  getPublicProject,
  addActorenvBuildenv,
  getActorenvList,
  deleteActorenv,
  getOperatorList,
  getActorenvDetail,
  getActorEnvOptions,
  getWorkflowspecList,
  saveOperator,
  deleteWorkflowspec,
  getWorkflowspecDetail,
  getOperatorDetail
};
