import MySelect from "@/components/mui/MySelect";
import MyDialog from "@/components/mui/MyDialog";
import { toJS } from "mobx";
import { useStores } from "@/store";
import { useEffect } from "react";

interface IProductSelectProps {
	open: boolean;
	setOpen: any;
	productId: string;
	setProductId: any;
	okText?: string;
	onConfirm?: any;
}

const ProductSelect = (props: IProductSelectProps) => {
	const {
		open,
		productId,
		setProductId,
		okText = "下一步",
		setOpen,
		onConfirm,
	} = props;
	const { productListStore } = useStores();

	useEffect(() => {
		if (!productId) {
			setProductId(toJS(productListStore.productList)[0].value);
		}
	}, [productId, productListStore.productList, setProductId]);

	const handleChange = (e: any) => {
		console.log(e);
		setProductId(e);
	};

	const handleConfirm = () => {
		setOpen(false);
		onConfirm && onConfirm();
	};

	return (
		<MyDialog
			open={open}
			title="选择产品"
			okText={okText}
			onClose={() => setOpen(false)}
			onConfirm={() => handleConfirm()}
		>
			<MySelect
				value={productId}
				onChange={(e) => handleChange(e)}
				options={[...productListStore?.productList] || []}
				fullWidth
			></MySelect>
		</MyDialog>
	);
};

export default ProductSelect;
