/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-11 11:56:58
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-07-27 14:30:57
 * @FilePath: /bkunyun/src/components/mui/MyProgress.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { ThemeProvider, createTheme } from "@mui/material/styles";
import { LinearProgress, LinearProgressProps } from "@mui/material";
import { useMemo } from "react";

interface IMyProgressProps extends Omit<LinearProgressProps, "color"> {
	color:
		| "disable"
		| "primary"
		| "secondary"
		| "error"
		| "info"
		| "success"
		| "warning"
		| "inherit";
}

const MyProgress = (props: IMyProgressProps) => {
	const { color, variant = "determinate", ...other } = props;

	const backgroundColorInfo = useMemo(() => {
		if (color === "info") {
			return {
				backgroundColor: "#1370FF",
			};
		}
		if (color === "success") {
			return {
				backgroundColor: "#0DD09B",
			};
		}
		if (color === "error") {
			return {
				backgroundColor: "#FF4E4E",
			};
		}
		if (color === "disable") {
			return {
				backgroundColor: "#C2C6CC",
			};
		}
	}, [color]);

	// /#C2C6CC
	const theme = createTheme({
		components: {
			MuiLinearProgress: {
				styleOverrides: {
					root: {
						borderRadius: 3,
						height: "6px",
						background: "#F0F2F5",
					},
					bar: {
						borderRadius: 3,
						...backgroundColorInfo
					},
				},
			},
		},
	});

	return (
		<ThemeProvider theme={theme}>
			<LinearProgress  variant={variant} {...other} />
		</ThemeProvider>
	);
};

export default MyProgress;
