/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-17 14:35:11
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-26 09:27:56
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import { observer } from "mobx-react-lite";
import { useEffect, useMemo, useState } from "react";
import { useLocation, useNavigate } from "react-router-dom";

import BasicInfo from "../../../../components/BasinInfo";
import RadioGroupOfButtonStyle from "@/components/CommonComponents/RadioGroupOfButtonStyle";
import useMyRequest from "@/hooks/useMyRequest";
import { getOperatorDetail } from "@/api/resourceCenter";
import { useStores } from "@/store";
import goback from "@/assets/project/goback.svg";

import styles from "./index.module.css";

const OperatorDetails = observer(() => {
	const contentTypeList = useMemo(() => {
		return [
			{ value: "flowChart", label: "流程图" },
			{ value: "parameterList", label: "参数列表" },
			{ value: "runScript", label: "运行脚本" },
		];
	}, []);

	/** 产品store */
	const { productListStore } = useStores();
	const navigate = useNavigate();

	/** 详情类型 */
	const [contentType, setContentType] = useState<string>("flowChart");
	/** 详情数据 */
	const [detailInfo, setDetailInfo] = useState<any>({});
	/** 获取算子详情 */
	const { run: fetchOperatorDetail } = useMyRequest(getOperatorDetail, {
		onSuccess: (res: any) => {
			if (res.message === "success") {
				/** 设置详情信息 */
				setDetailInfo(res.data);
			}
		},
	});
	const location = useLocation();
	const locationInfo: any = location?.state;

	const {
		title = "",
		version = "",
		productId = "",
		createdTime = "",
		creator = "",
		description = "",
		type,
	} = detailInfo;

	/** 切换类型 */
	const handleRadio = (val: string) => {
		setContentType(val);
	};

	const productText = useMemo(() => {
		const result = productListStore.productList?.filter((item) => {
			return item.value === productId;
		});
		return result?.length ? result[0].label : "";
	}, [productListStore.productList, productId]);

	useEffect(() => {
		fetchOperatorDetail(locationInfo.id);
	}, [fetchOperatorDetail, locationInfo.id]);

	return (
		<div className={styles.detailsBox}>
			<div className={styles.titleBox}>
				<img
					className={styles.goBackIcon}
					src={goback}
					alt=""
					onClick={() =>
						navigate("/utility/resourceCenter/userResources", {
							state: { defaultTab: "USERRESOURCES_FLOE" },
						})
					}
				/>
				<div className={styles.title}>{title}</div>
				<div className={styles.type}>
					{type === "BATCH" ? "批算子" : "流算子"}
				</div>
			</div>
			<h2 className={styles.baseInfoBox}>基础信息</h2>
			<div style={{ border: "1px solid #EBEDF0" }}>
				<BasicInfo
					infoList={[
						{ label: "所属产品", value: productText },
						{
							label: "创建时间",
							value: createdTime,
						},
						{ label: "创建人", value: creator },
						{ label: "算子版本", value: version },
						{ label: "应用环境", value: "1" },
					]}
				/>
				<BasicInfo infoList={[{ label: "描述", value: description }]} />
			</div>
			<div style={{ padding: "26px 0 16px 0" }}>
				<RadioGroupOfButtonStyle
					RadiosBoxStyle={{ width: 254 }}
					value={contentType}
					radioOptions={contentTypeList}
					handleRadio={handleRadio}
				/>
			</div>
			<div>11</div>
		</div>
	);
});

export default OperatorDetails;
