import style from "./index.module.css";
import usePass from "@/hooks/usePass";
import UserResourcesTemplate from "./UserResourcesTemplate";
import UserResourcesEnvironment from "./UserResourcesEnvironment";
import { useLocation } from "react-router-dom";
import { useMemo } from "react";
import Tabs from "@/components/mui/MyTabs";
import WorkflowOperator from "./WorkflowOperator";
import OperatorDetails from "./WorkflowOperator/components/OperatorDetails";
const UserResources = () => {
	const isPass = usePass();
	const location: any = useLocation();
	const tabList = useMemo(() => {
		return [
			{
				label: "工作流模版",
				value: "USERRESOURCES_TEMPLATE",
				component: <UserResourcesTemplate />,
				hide: !isPass("USERRESOURCES_TEMPLATE"),
			},
			{
				label: "工作流算子",
				value: "USERRESOURCES_FLOE",
				component: <WorkflowOperator />,
				hide: !isPass("USERRESOURCES_FLOE"),
			},
			{
				label: "应用环境",
				value: "USERRESOURCES_ENVIRONMENT",
				component: <UserResourcesEnvironment />,
				hide: !isPass("USERRESOURCES_ENVIRONMENT"),
			},
		];
	}, [isPass]);

	return (
		<div className={style.userResources}>
			<Tabs
				title="个人资源"
				tabList={tabList}
				defaultValue={location?.state?.defaultTab || "USERRESOURCES_TEMPLATE"}
				tabPanelSx={{ padding: "0" }}
			/>
			{/* <OperatorDetails /> */}
		</div>
	);
};

export default UserResources;
