/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-17 14:35:11
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-18 14:52:48
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import MyTooltip from "@/components/mui/MyTooltip";
import { ReactElement, ReactNode } from "react";
import styles from "./index.module.css";

interface IProps {
	infoList: IInfoItem[];
}

export interface IInfoItem {
	label: string;
	value: string | ReactNode | ReactElement;
	flex?: number;
}

const BasicInfo = (props: IProps) => {
	const { infoList } = props;
	return (
		<div className={styles.basicInfoBox}>
			<div className={styles.trHeaderBox}>
				{infoList.map((item) => {
					return (
						<div
							style={{
								width:
									infoList?.length > 1
										? `calc(100% / ${infoList.length})`
										: "100%",
							}}
						>
							{item.label}
						</div>
					);
				})}
			</div>
			<div className={styles.trBodyBox}>
				{infoList.map((item) => {
					return (
						<div
							style={{
								width:
									infoList?.length > 1
										? `calc(100% / ${infoList.length})`
										: "100%",
							}}
						>
							<MyTooltip
								title={typeof item.value === "string" ? item.value : ""}
							>
								<span>{item.value}</span>
							</MyTooltip>
						</div>
					);
				})}
			</div>
		</div>
	);
};

export default BasicInfo;
