// 从下往上弹的全屏抽屉
// import { useState } from "react";
import style from "./index.module.css";
import classNames from "classnames";
import CloseOutlinedIcon from "@mui/icons-material/CloseOutlined";

type IFullScreenDrawerProps = {
	children: React.ReactNode;
	handleClose: any;
	zIndex?: any;
};

const FullScreenDrawer = (props: IFullScreenDrawerProps) => {
	const { children, handleClose } = props;

	const handleReadyToClose = () => {
		handleClose();
	};
	return (
		<div
			className={classNames({
				[style.drawerBox]: true,
			})}
			style={{ zIndex: props.zIndex }}
		>
			<div
				className={classNames({
					[style.closeBox]: true,
				})}
			>
				<CloseOutlinedIcon
					className={style.closeiIcon}
					onClick={() => handleReadyToClose()}
				/>
			</div>
			<div
				className={classNames({
					[style.contentBox]: true,
				})}
			>
				{children}
			</div>
		</div>
	);
};

export default FullScreenDrawer;
