import localStorageKey from "@/utils/localStorageKey";
import { AxiosRequestHeaders } from "axios";

const getHeader = (
  headers: AxiosRequestHeaders | undefined
): AxiosRequestHeaders => {
  let Authorization: string =
    `Bearer ` +
      JSON.parse(localStorage.getItem(localStorageKey.TOKEN) || "{}")
        ?.access_token || "";

  return {
    "Content-Type": "application/json; charset=UTF-8",
    Authorization,
    ...headers,
  };
};

export default getHeader;
