import React from "react";
import TextField from '@mui/material/TextField';
import MenuItem from '@mui/material/MenuItem';
import { makeStyles } from "@mui/styles";
import cx from "classnames"
const useStyles = makeStyles({
    MuiOutlinedInputInputLarge: { padding: "13.5px 15px", MozAppearance: 'textfield' },
    MuiOutlinedInputInput: { padding: "12px 15px", "&::placeholder": { fontSize: "14px" }, MozAppearance: 'textfield' },
    MuiOutlinedInputInputSmall: { padding: "10px 15px", "&::placeholder": { fontSize: "13px" }, MozAppearance: 'textfield' },
    MuiOutlinedInputInputXsmall: { padding: "8px 15px", "&::placeholder": { fontSize: "12px" }, MozAppearance: 'textfield' },
    outlinedLarge: { transform: "translate(14px, 15.5px) scale(1)", fontSize: '14px', fontWeight: '400', color: '#707070' },
    outlined: { transform: "translate(14px, 14px) scale(1)", fontSize: '14px', fontWeight: '400', color: '#707070' },
    outlinedSmall: { transform: "translate(14px, 11px) scale(1)", fontSize: '14px', fontWeight: '400', color: '#707070' },
    outlinedXsmall: { transform: "translate(12px, 11px) scale(1)", fontSize: '13px', fontWeight: '400', color: '#707070' },
    notchedOutline: { borderColor: "rgba(216, 216, 216, 1)" },
    root: {
        "&:hover": {
            "& .MuiOutlinedInput-notchedOutline": { borderColor: "rgba(19, 110, 250, 0.9)" }
        },
    },
    error: {
        "& .MuiOutlinedInput-notchedOutline": {
            borderColor: "#D62C1F !important"
        },
    },
    disabled: {
        color: "#E3E3E3 !important",
        "& .MuiOutlinedInput-notchedOutline": { borderColor: "#E3E3E3 !important" },
        "&:hover": {
            "& .MuiOutlinedInput-notchedOutline": { borderColor: "#E3E3E3 !important" }
        },
    },
    errorLabel: { color: "#D62C1F !important" },
    errorFormHelperTextProps: { color: "#D62C1F !important", fontSize: "12px", lineHeight: '14px' },
    SelectPropsright: { textAlign: "right" },
    SelectPropscenter: { textAlign: "center" },
    SelectPropsleft: { textAlign: "left" },
    selectProp: { fontSize: "14px" },
    selectPropsLarge: { fontSize: "14px" },
    selectPropsSmall: { fontSize: "13px" },
    selectPropsXsmall: { fontSize: "12px" },
    adornedEnd: { paddingRight: "8px" },
    defaultSelectStyle: { fontSize: "14px" }
})
export default props => {
    const classes = useStyles();
    const { label, type, variant, disabled, onChange, placeholder, value, textAlign, customClass,
        autoFocus, defaultValue, error, fullWidth, margin, select, disabledClass, onBlur, selectStyle,
        multiline, required, rows, startAdornment, endAdornment, helperText, size, onkeydown, selectSize, onFocus

    } = props;
    const onChangeDefault = () => { }
    const resizeBys = (sty) => {
        switch (size) {
            case "large":
                return sty + "Large";
            case "small":
                return sty + "Small";
            case "xsmall":
                return sty + "Xsmall";
            default:
                return sty;
        }
    }
    const reSelectSizeBys = (sty) => {
        switch (selectSize) {
            case "large":
                return sty + "Large";
            case "small":
                return sty + "Small";
            case "xsmall":
                return sty + "Xsmall";
            default:
                return sty;
        }
    }
    const onBlurDefault = () => {

    }
    const onFocusDefault = () => { }
    if (![undefined, null].includes(value)) {
        return (
            <TextField
                label={label || ""}
                autoFocus={autoFocus || false}
                type={type || "text"}
                value={value || ""}
                placeholder={placeholder || ""}
                variant={variant || "outlined"}
                select={select ? true : false}
                disabled={disabled || false}
                onChange={onChange || onChangeDefault}
                onBlur={onBlur || onBlurDefault}
                error={error || false}
                helperText={helperText || ""}
                fullWidth={fullWidth || false}
                onFocus={onFocus || onFocusDefault}
                rows={rows || 1}
                multiline={multiline || false}
                required={required || false}
                InputProps={{
                    margin: margin || "none",
                    classes: {
                        root: classes.root,
                        input: cx({
                            width: '320px',
                            height: '32px',
                            [classes[resizeBys("MuiOutlinedInputInput")]]: true,
                            [classes[`SelectProps${textAlign}`]]: textAlign,
                            [customClass]: customClass,
                        }),
                        notchedOutline: classes.notchedOutline,
                        error: classes.error,
                        disabled: disabledClass || classes.disabled,
                        adornedEnd: classes.adornedEnd
                    },
                    startAdornment: startAdornment || "",
                    endAdornment: endAdornment || ""
                }}
                InputLabelProps={{
                    classes: {
                        outlined: classes[resizeBys("outlined")],
                        error: classes.errorLabel
                    }
                }}
                FormHelperTextProps={{
                    classes: {
                        root: classes.rootFormHelperTextProps,
                        error: classes.errorFormHelperTextProps
                    }
                }}
                SelectProps={{
                    native: (select && select.native) || false,
                    classes: {
                        outlined: textAlign ? classes[`SelectProps${textAlign}`] : classes['SelectPropsleft'],
                        selectMenu: classes[reSelectSizeBys("selectProps")]
                    }
                }}
            >
                {
                    select && select.json && select.json.length > 0 && select.json.map((option, key) => {
                        return (
                            <MenuItem key={key} disabled={option.disabled || false} value={option.value} className={selectStyle || classes.defaultSelectStyle}>
                                {option.label}
                            </MenuItem>
                        )
                    })
                }
            </TextField>
        )
    }
    return (
        <TextField
            label={label || ""}
            autoFocus={autoFocus || false}
            type={type || "text"}
            defaultValue={defaultValue || ""}
            placeholder={placeholder || ""}
            variant={variant || "outlined"}
            select={select ? true : false}
            disabled={disabled || false}
            onChange={onChange || onChangeDefault}
            onBlur={onBlur || onBlurDefault}
            error={error || false}
            helperText={helperText || ""}
            fullWidth={fullWidth || false}
            rows={rows || 1}
            multiline={multiline || false}
            required={required || false}
            onKeyDown={onkeydown || (() => { })}
            InputProps={{
                margin: margin || "none",
                classes: {
                    root: classes.root,
                    input: cx({
                        [classes[resizeBys("MuiOutlinedInputInput")]]: true,
                        [classes[`SelectProps${textAlign}`]]: textAlign,
                        [customClass]: customClass
                    }),
                    notchedOutline: classes.notchedOutline,
                    error: classes.error,
                    disabled: disabledClass || classes.disabled,
                    adornedEnd: classes.adornedEnd
                },
                startAdornment: startAdornment || "",
                endAdornment: endAdornment || ""
            }}
            InputLabelProps={{
                classes: {
                    outlined: classes[resizeBys("outlined")],
                    error: classes.errorLabel
                }
            }}
            FormHelperTextProps={{
                classes: {
                    root: classes.rootFormHelperTextProps,
                    error: classes.errorFormHelperTextProps
                }
            }}
            SelectProps={{
                native: (select && select.native) || false,
                classes: {
                    outlined: textAlign ? classes[`SelectProps${textAlign}`] : classes['SelectPropsleft'],
                }
            }}
        >
            {
                select && select.json && select.json.length > 0 && select.json.map((option, key) => {
                    return (
                        <MenuItem key={key} disabled={option.disabled || false} value={option.value} className={selectStyle || classes.defaultSelectStyle}>
                            {option.label}
                        </MenuItem>
                    )
                })
            }
        </TextField>
    )
}