/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-08-02 11:43:28
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-09-01 19:49:39
 * @FilePath: /bkunyun/src/views/Project/components/ProjectListPopper/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import smallLogo from "@/assets/project/projectIconSmall.svg";
import style from "./index.module.css";
import { InputBase, IconButton } from "@mui/material";
import SearchIcon from "@mui/icons-material/Search";
import AddIcon from "@mui/icons-material/Add";
import classNames from "classnames";
import { useStores } from "@/store/index";
import moment from "moment";
import React, { useMemo, useState } from "react";
import { useClickAway } from "ahooks";
import { toJS } from "mobx";
import { observer } from "mobx-react-lite";

const ProjectListPopper = observer((props: any) => {
	const { handleChangeCurrentProject, handleClickOpen, setProjectListOpen } =
		props;
	const { currentProjectStore } = useStores();
	const projectList = toJS(currentProjectStore.projectList);
	const currentProjectId = toJS(currentProjectStore.currentProjectInfo.id);
	// 通过名称本地搜索
	const [name, setName] = useState("");
	const nameChange = (e: any) => {
		setName(e.target.value);
	};

	const getPower = (projectRole: string) => {
		if (projectRole === "VIEWER") {
			return "查看者";
		} else if (projectRole === "USER") {
			return "研究员";
		} else if (projectRole === "MANAGER") {
			return "管理员";
		} else if (projectRole === "OWNER") {
			return "所有者";
		} else {
			return "";
		}
	};

	const list = useMemo(() => {
		return projectList
			.filter((item: any) => {
				return item.name?.indexOf(name) !== -1;
			})
			.map((item) => {
				return {
					...item,
					power: getPower(item.projectRole || ""),
				};
			});
	}, [projectList, name]);
	console.log(list);

	const handleProjectBox = (e: React.SyntheticEvent) => {
		setProjectListOpen(false);
	};

	useClickAway(
		() => {
			setProjectListOpen(false);
		},
		() => document.getElementById("use-click-projectList-mainBox")
	);

	return (
		<div className={style.projectBox} onClick={handleProjectBox}>
			<div
				className={style.mainBox}
				id="use-click-projectList-mainBox"
				onClick={(e: any) => e.stopPropagation()}
			>
				<div className={style.searchBox}>
					<IconButton
						type="submit"
						className={style.searchButton}
						aria-label="search"
					>
						<SearchIcon
							className={style.searchIcon}
							style={{ color: "#8A9099", fontSize: "22px" }}
						/>
					</IconButton>
					<InputBase
						className={style.searchInput}
						placeholder="请输入项目名称"
						inputProps={{ "aria-label": "请输入项目名称" }}
						value={name}
						onChange={nameChange}
						sx={{
							fontSize: "14px",
							// color: "rgba(194, 198, 204, 1)",
							height: "22px",
						}}
					/>
					<IconButton
						onClick={handleClickOpen}
						type="submit"
						className={style.add}
						aria-label="search"
					>
						<AddIcon className={style.addIcon} />
					</IconButton>
				</div>
				<div className={style.projectlist}>
					{list.length ? (
						list.map((item: any) => {
							return (
								<div
									className={classNames({
										[style.projectli]: true,
										[style.projectliActive]: item.id === currentProjectId,
									})}
									key={item.id}
									onClick={() => handleChangeCurrentProject(item)}
								>
									<div className={style.projectliBorderBox}>
										<img
											src={smallLogo}
											alt=""
											className={style.projectliLogo}
										/>
										<div className={style.projectliInfo}>
											<div className={style.projectName}>{item.name}</div>
											<div className={style.projectOwnerTime}>
												<span className={style.projectOwner} title={item.owner}>
													{item.power}
												</span>
												<span className={style.projectTime}>
													{moment(item.createdAt).format("YYYY-MM-DD")}
												</span>
											</div>
										</div>
									</div>
								</div>
							);
						})
					) : (
						<div className={style.noProjectBox}>暂无相关项目</div>
					)}
				</div>
			</div>
		</div>
	);
});

export default ProjectListPopper;
