import request from "@/utils/axios/service";
import Api from "./api_manager";

function current() {
  return request({
    url: Api.API_USER_FETCH,
    method: "get",
  });
}

function menu() {
  return request({
    url: "/accounts/menu-mock",
    method: "get",
  });
}

type projectListParams = {
  product: string;
  name?: string;
};

// 查询当前用户可以看到的项目列表
const product = (params: projectListParams) => {
  return request({
    url: Api.API_PROJECT_LIST,
    method: "get",
    params,
  });
};

export { current, menu, product };
