import React from 'react';
import ErrorOutlineIcon from '@material-ui/icons/ErrorOutline';
import Text from "@/commons/components/Material.Ui/Text"
import makeStyles from "@material-ui/styles/makeStyles";
import { Grid } from '@material-ui/core';
const useStyles = makeStyles({
    tipBody: { width: "100%", height: "40px", background: "#FFEDED", boxShadow: "0px 2px 6px 0px rgba(189, 14, 0, 0.03)", borderRadius: "4px", display: "flex", alignItems: "center" },
    root: { marginRight: 0 }
})
export default props => {
    const { text } = props;
    const classes = useStyles()
    return (
        <Grid className={classes.tipBody}>
            <ErrorOutlineIcon style={{ color: "#FF4E4E", margin: "0px 10px 0px 20px" }} fontSize="small" />
            <Text color={"error"} variant={"subtitle2"} text={text} />
        </Grid>
    )
}