import {
  Button,
  Dialog,
  DialogActions,
  DialogContent,
  DialogTitle,
} from "@mui/material";
import { useState } from "react";
import React, { useImperativeHandle } from "react";
// import LoadingButton from '@mui/lab/LoadingButton';
const MyDialog = (props: any) => {
  const [open, setOpen] = useState(false);
  const { title, handleSubmit } = props;

  const handleClickOpen = () => {
    setOpen(true);
  };

  const handleClose = () => {
    setOpen(false);
  };

  useImperativeHandle(props.onRef, () => {
    return {
      handleClickOpen: handleClickOpen,
      handleClose: handleClose,
    };
  });

  return (
    <Dialog
      open={open}
      onClose={handleClose}
      aria-labelledby="form-dialog-title"
    >
      {title && <DialogTitle id="form-dialog-title">{title}</DialogTitle>}
      <DialogContent>{props.children}</DialogContent>
      <DialogActions>
        <Button onClick={handleClose} color="primary">
          取消
        </Button>
        <Button onClick={handleSubmit} color="primary">
          确认
        </Button>
      </DialogActions>
    </Dialog>
  );
};

export default MyDialog;
