import style from "./NoProject.module.css";
import noData from "@/assets/project/noData.svg";
import { Button } from "@mui/material";
import AddIcon from "@mui/icons-material/Add";
import MyDialog from "../MyDialog";
import React from "react";

const NoProject = () => {
  let DialogRef: any = React.createRef();
  const handleClickOpen = () => {
    DialogRef.current.handleClickOpen();
  };

  const handleSubmit = () => {
    console.log("handleSubmitfff");
  };

  return (
    <div className={style.noProject}>
      <img src={noData} alt="" className={style.noDataImg} />
      <div className={style.text1}>当前产品暂无项目</div>
      <div className={style.text2}>请先创建项目</div>
      <Button
        variant="contained"
        size="large"
        className={style.button}
        startIcon={<AddIcon />}
        onClick={handleClickOpen}
        style={{ backgroundColor: "#1370ff", color: "#fff" }}
      >
        创建项目
      </Button>
      <MyDialog handleSubmit={handleSubmit} onRef={DialogRef} title="新建项目">
        <div>123</div>
      </MyDialog>
    </div>
  );
};

export default NoProject;
