/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-02 18:43:59
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useState, useMemo } from "react";

import { Box } from "@mui/system";
import projectImg from "@/assets/project/projectIconSmall.svg";
import ProjectMembers from "./ProjectMembers";
import BaseInfo from "./BaseInfo";
import Tabs from "@/components/mui/Tabs";

const ProjectSetting = () => {
  const [value, setValue] = useState("projectMember");

  const tabList = useMemo(() => {
    return [
      {
        label: "项目成员",
        value: "projectMember",
        component: <ProjectMembers />,
      },
      {
        label: "基础信息",
        value: "baseInfo",
        component: <BaseInfo />,
      },
    ];
  }, []);

  const changeTabs = (val: string) => {
    setValue(val);
  };

  return (
    <Box style={{ padding: 24 }}>
      <div>
        <img src={projectImg} alt="项目logo" />
        <span>项目名称A</span>
      </div>

      <Box sx={{ width: "100%", typography: "body1" }}>
        <Tabs value={value} onChange={changeTabs} tabList={tabList} />
      </Box>
    </Box>
  );
};

export default memo(ProjectSetting);
