// import { useEffect } from "react";
import smallLogo from "@/assets/project/projectIconSmall.svg";
import style from "./index.module.css";
import { InputBase, IconButton } from "@mui/material";
import SearchIcon from "@mui/icons-material/Search";
import AddIcon from "@mui/icons-material/Add";
import { useState } from "react";
import { useStores } from "@/store/index";
// import { product } from "@/api/project_api";
import moment from "moment";

const ProjectListPopper = () => {
  const { currentProjectStore } = useStores();
  console.log("currentProjectStore", currentProjectStore);
  console.log("currentProjectInfo", currentProjectStore.currentProjectInfo);
  console.log("projectList", currentProjectStore.projectList);
  const [projectList, setProjectList] = useState<any>([]);

  // const { data, error, loading, run } = useMyRequest(product, {
  //   manual: true,
  //   onSuccess: (result, params) => {
  //     console.log(result);
  //     setProjectList(result.data);
  //   },
  // });
  // useEffect(() => {
  //   run();
  // }, []);
  const run = () => {
    console.log("run");
  };

  return (
    <div className={style.projectBox}>
      {/* 123 */}
      <div className={style.searchBox} onClick={() => run()}>
        <IconButton
          type="submit"
          className={style.searchButton}
          aria-label="search"
        >
          <SearchIcon className={style.searchIcon} />
        </IconButton>
        <InputBase
          className={style.searchInput}
          placeholder="请输入项目名称"
          inputProps={{ "aria-label": "请输入项目名称" }}
        />
        <IconButton type="submit" className={style.add} aria-label="search">
          <AddIcon className={style.addIcon} />
        </IconButton>
      </div>
      <div className={style.projectlist}>
        {projectList.map((item: any) => {
          return (
            <div className={style.projectli}>
              <img src={smallLogo} alt="" className={style.projectliLogo} />
              <div className={style.projectliInfo}>
                <div className={style.projectName}>{item.name}</div>
                <div className={style.projectOwnerTime}>
                  <span className={style.projectOwner}>{item.owner}</span>
                  <span className={style.projectTime}>
                    {moment(item.createdAt).format("YYYY-MM-DD")}
                  </span>
                </div>
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
};

export default ProjectListPopper;
