// 应用环境
import { useEffect, useState } from "react";
import style from "./index.module.css";
import SearchInput from "@/components/BusinessComponents/SearchInput";
import MySelect from "@/components/mui/MySelect";
import MyButton from "@/components/mui/MyButton";
import MyTable from "@/components/mui/MyTableNew";
import useMyRequest from "@/hooks/useMyRequest";
import { getActorenvList } from "@/api/resourceCenter";
import moment from "moment";
import jobFail from "@/assets/project/jobFail.svg";
import jobRun from "@/assets/project/jobRun.svg";
import jobSue from "@/assets/project/jobSue.svg";
import AddEnvironment from "./AddEnvironment";
import DeleteEnvironment from "./DeleteEnvironment";

const UserResourcesEnvironment = () => {
	const [addOpen, setAddopen] = useState(false);
	const [title, setTitle] = useState("");
	const [type, setType] = useState<"BATCH" | "FLOW" | "">("");
	const [list, setList] = useState([]);
	const [page, setPage] = useState(0);
	const [count, setCount] = useState(0);
	const [size, setSize] = useState(20);
	const [id, setId] = useState("");
	const [deleteOpen, setDeleteOpen] = useState(false);
	const headCells: Array<any> = [
		{
			id: "title",
			label: "环境名称",
		},
		{
			id: "type",
			label: "环境类型",
			width: 100,
		},
		{
			id: "createdTime",
			label: "创建时间",
			width: 180,
		},
		{
			id: "status",
			label: "构建状态",
			width: 150,
		},
		{
			id: "caozuo",
			label: "操作",
			width: 140,
		},
	];
	const { run: getList } = useMyRequest(getActorenvList, {
		onSuccess: (res) => {
			console.log(res);
			setList(res.data.content);
			setCount(res.data.totalPages - 1);
		},
	});

	const pageChange = (value: number) => {
		setPage(value - 1);
	};

	useEffect(() => {
		if (!addOpen && !deleteOpen) {
			getList({
				page,
				size,
				title,
				type,
			});
		}
	}, [getList, page, size, title, type, addOpen, deleteOpen]);

	const renderType = (item: any) => {
		if (item.type === "BATCH") {
			return "批式";
		} else if (item.type === "FLOW") {
			return "流式";
		} else {
			return "";
		}
	};

	const renderStatus = (item: any) => {
		if (item.status === "PENDING") {
			return (
				<div className={style.statusBox}>
					<img src={jobRun} alt="" />
					<span className={style.status}>准备构建</span>
				</div>
			);
		} else if (item.status === "CREATING") {
			return (
				<div className={style.statusBox}>
					<img src={jobRun} alt="" />
					<span className={style.status}>正在构建</span>
				</div>
			);
		} else if (item.status === "FAILED") {
			return (
				<div className={style.statusBox}>
					<img src={jobFail} alt="" />
					<span className={style.status}>构建失败</span>
				</div>
			);
		} else if (item.status === "CREATED") {
			return (
				<div className={style.statusBox}>
					<img src={jobSue} alt="" />
					<span className={style.status}>构建完成</span>
				</div>
			);
		} else {
			return "";
		}
	};

	const renderCreatedTime = (item: any) => {
		return moment(new Date(item.createdTime)).format("yyyy-MM-DD hh:mm:ss");
	};

	const handleDelete = (item: any) => {
		setId(item.id);
		setDeleteOpen(true);
	};

	const renderButtons = (item: any) => {
		if (item.status === "FAILED") {
			return (
				<>
					<MyButton
						text="详情"
						style={{
							position: "relative",
							left: "-10px",
							minWidth: "10px",
							height: "22px",
							padding: "0 10px",
						}}
						variant="text"
						size="medium"
					/>
					<MyButton
						onClick={() => handleDelete(item)}
						text="删除"
						style={{
							position: "relative",
							left: "-10px",
							minWidth: "10px",
							height: "22px",
							padding: "0 10px",
						}}
						variant="text"
						size="medium"
						color="error"
					/>
				</>
			);
		} else {
			return (
				<MyButton
					text="详情"
					style={{
						position: "relative",
						left: "-10px",
						minWidth: "10px",
						height: "22px",
						padding: "0 10px",
					}}
					variant="text"
					size="medium"
					// onClick={() => hanleDownloadFile(item)}
				/>
			);
		}
	};

	return (
		<div className={style.environment}>
			<div className={style.top}>
				<div className={style.topLeft}>
					<SearchInput
						sx={{ width: 340, marginRight: "16px" }}
						onKeyUp={(e: any) => {
							if (e.keyCode === 13) {
								setTitle(e.target.value);
							}
						}}
					></SearchInput>
					{!addOpen && (
						<MySelect
							title="环境类型"
							isTitle={true}
							options={[
								{
									label: "批式",
									value: "BATCH",
								},
								{
									label: "流式",
									value: "FLOW",
								},
							]}
							value={type}
							onChange={(e: any) => setType(e)}
							sx={{ width: "150px", height: "32px" }}
						></MySelect>
					)}
				</div>
				<div className={style.topRight}>
					<MyButton
						text="构建应用环境"
						img={
							<span
								style={{ fontSize: "14px", marginRight: "8px" }}
								className="iconfont icon-dianzan"
							></span>
						}
						onClick={() => setAddopen(true)}
					></MyButton>
				</div>
			</div>
			<div className={style.tableBox}>
				<MyTable
					rows={list.map((item: any) => ({
						...item,
						type: renderType(item),
						status: renderStatus(item),
						caozuo: renderButtons(item),
						createdTime: renderCreatedTime(item),
					}))}
					headCells={headCells}
					fixedHead={true}
					hasTableFooter={true}
					page={page}
					count={count}
					pageChange={pageChange}
				></MyTable>
			</div>
			{addOpen && <AddEnvironment setAddopen={setAddopen}></AddEnvironment>}
			{deleteOpen && (
				<DeleteEnvironment
					id={id}
					open={deleteOpen}
					setDeleteOpen={setDeleteOpen}
				></DeleteEnvironment>
			)}
		</div>
	);
};

export default UserResourcesEnvironment;
