import { makeStyles } from "@mui/styles";

/*
 *@分割线=======================================================================================================================================
 *@Description: 排序算法
 *@File:
 *@param: {} []
 *@MethodAuthor:  dawei.liu
 *@Date: 2021-07-22 14:42:51
 */
export function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) return -1;
  if (b[orderBy] > a[orderBy]) return 1;
  return 0;
}
/*
 *@分割线=======================================================================================================================================
 *@Description: 表格排序
 *@File: /commons/components/Material.Ui/Table.jsx
 *@param: {} []
 *@MethodAuthor:  dawei.liu
 *@Date: 2021-07-22 14:42:36
 */
export function getComparator(order, orderBy) {
  return order === "desc"
    ? (a, b) => descendingComparator(a, b, orderBy)
    : (a, b) => -descendingComparator(a, b, orderBy);
}
/*
 *@分割线=======================================================================================================================================
 *@Description: 排序算法
 *@File:
 *@param: {} []
 *@MethodAuthor:  dawei.liu
 *@Date: 2021-07-22 14:42:24
 */
export function stableSort(array, comparator) {
  const stabilizedThis = array.map((el, index) => [el, index]);
  stabilizedThis.sort((a, b) => {
    const order = comparator(a[0], b[0]);
    if (order !== 0) return order;
    return a[1] - b[1];
  });
  return stabilizedThis.map((el) => el[0]);
}
/*
 *@分割线=======================================================================================================================================
 *@Description: table toolbar styles
 *@File: EnhancedTableToolbar
 *@param: {} []
 *@MethodAuthor:  dawei.liu
 *@Date: 2021-07-22 14:41:53
 */
export const useToolbarStyles = makeStyles((theme) => ({
  root: {
    paddingLeft: theme.spacing(2),
    paddingRight: theme.spacing(1),
  },
  highlight:
    theme.palette.type === "light"
      ? {
          color: theme.palette.primary.main,
          backgroundColor: "red",
        }
      : {
          color: theme.palette.text.primary,
          backgroundColor: theme.palette.primary.dark,
        },
  title: { flex: "1 1 100%" },
}));
/*
 *@分割线=======================================================================================================================================
 *@Description: 样式
 *@File:
 *@param: {theme} [theme]
 *@MethodAuthor:  dawei.liu
 *@Date: 2021-07-22 14:40:37
 */
export const useStyles = makeStyles((theme) => ({
  root: { width: "100%", position: "relative" },
  paper: { width: "100%", marginBottom: 8 },
  elevation1: { boxShadow: "none", padding: "20px" },
  elevationNoPadding: { boxShadow: "none", padding: "0" },
  table: { minWidth: 500 },
  visuallyHidden: {
    border: 0,
    clip: "rect(0 0 0 0)",
    height: 1,
    margin: -1,
    overflow: "hidden",
    padding: 0,
    position: "absolute",
    top: 20,
    width: 1,
  },
  LinearProgressStyle: {
    position: "absolute",
    left: 0,
    top: "0",
    width: "100%",
  },
  TypographyStyle: {
    height: "300px",
    width: "100%",
    justifyContent: "center",
    alignItems: "center",
    color: "#666",
    fontSize: "16px",
    textAlign: "center",
  },
  bodyTableCell: {
    color: "#222222",
    fontSize: "12px",
    borderBottom: "1px solid rgba(34, 34, 34, 0.08)",
    padding: "10px",
    paddingLeft: "16px",
  },
  headTableCell: {
    color: "rgba(34, 34, 34, 0.65)",
    fontSize: "12px",
    padding: "16px",
  },
  rootTableContainer: {
    position: "relative",
    overflowX: "auto",
    maxHeight: "700px",
  },
  TableHeadClasses: { backgroundColor: "rgba(34, 34, 34,  0.03)" },
  bodyTableCellRoot: { borderBottom: "1px solid rgba(34, 34, 34, 0.08)" },
  TypographyboderStyle: {
    height: "300px",
    width: "100%",
    justifyContent: "center",
    alignItems: "center",
    color: "#666",
    fontSize: "16px",
    textAlign: "center",
    borderBottom: "none",
  },
  rootTableboderContainer: {
    position: "relative",
    overflowX: "auto",
    maxHeight: "700px",
    border: "1px solid rgb(216, 216, 216)",
  },
  cancelHoverStyle: { "&:hover": { background: "none !important" } },
}));
