import { useCallback } from "react";
import { useImmer } from "use-immer";

const useIndex = () => {
  const [productAnchorEl, setProductAnchorEl] = useImmer(null);
  const productOpen = Boolean(productAnchorEl);

  const [utilityAnchorEl, setUtilityAnchorEl] = useImmer(null);
  const utilityOpen = Boolean(utilityAnchorEl);

  const handleProductClick = useCallback((event: any) => {
    setProductAnchorEl(event.currentTarget);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const handleUtilityClick = useCallback((event: any) => {
    setUtilityAnchorEl(event.currentTarget);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const handleClose = useCallback(() => {
    setProductAnchorEl(null);
    setUtilityAnchorEl(null);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  return {
    productAnchorEl,
    utilityAnchorEl,
    productOpen,
    utilityOpen,
    handleProductClick,
    handleUtilityClick,
    handleClose,
  };
};

export default useIndex;
