import { useStores } from "@/store";
import { toJS } from "mobx";
import templateIcon from "@/assets/resourceCenter/templateIcon.svg";
import style from "./index.module.scss";

interface ITemplateItemPorps {
	templateInfo: any;
	footer: any;
}

const TemplateItem = (props: ITemplateItemPorps) => {
	const { templateInfo, footer } = props;
	const { productListStore } = useStores();
	const getProductName = (productId: string) => {
		let res = "-";
		toJS(productListStore.productList).forEach((item) => {
			if (item.value === productId) {
				res = item.label;
			}
		});
		return res;
	};

	return (
		<div className={style.templateBox}>
			<div className={style.templateTop}>
				<div className={style.templateTopItem}>
					{getProductName(templateInfo.productId)}
				</div>
				{templateInfo.creator !== "root" && (
					<>
						<div className={style.templateTopLine}></div>
						<div className={style.templateTopItem}>自定义</div>
					</>
				)}
				<div className={style.templateTopLine}></div>
				<div className={style.templateTopItem}>{templateInfo.version}</div>
				<div className={style.templateTopLine}></div>
				<div className={style.templateTopItem}>{templateInfo.updatedTime}</div>
			</div>
			<div className={style.templateTitleBox}>
				<img src={templateIcon} alt="" />
				<div className={style.templateTitle}>{templateInfo.title}</div>
			</div>
			<div className={style.templateDesc}>{templateInfo.description}</div>
			{footer && footer()}
		</div>
	);
};

export default TemplateItem;
