/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-18 09:32:40
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-25 14:48:51
 * @FilePath: /bkunyun/src/views/ResourceCenter/components/SwitchBatchFolw/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import batchImg from "@/assets/resourceCenter/batchImg.svg";
import flowImg from "@/assets/resourceCenter/flowImg.svg";

import classNames from "classnames";
import goback from "@/assets/project/goback.svg";
import style from "./index.module.css";

type ISwitchBatchFolwProps = {
	topImg?: string;
	bottomImg?: string;
	active: "BATCH" | "FLOW";
	type?: "edit";
	setActive: any;
	goBack: any;
};

const SwitchBatchFolw = (props: ISwitchBatchFolwProps) => {
	const { active, setActive, goBack, topImg, bottomImg, type } = props;
	return (
		<div className={style.switchBatchFolw}>
			<div className={style.goBackBox}>
				<img
					className={style.goBackIcon}
					src={goback}
					alt=""
					onClick={() => goBack()}
				/>
				<span className={style.goBackText}>返回</span>
			</div>
			<div className={style.switchBox}>
				{/* type为edit 只显示一个 */}
				{type === "edit" && active !== "BATCH" ? null : (
					<div
						className={classNames({
							[style.switchItem]: true,
							[style.activeSwitchItem]: active === "BATCH",
						})}
					>
						<img
							onClick={() => setActive("BATCH")}
							className={classNames({
								[style.itemImg]: true,
								[style.activeImg]: active === "BATCH",
							})}
							src={topImg || batchImg}
							alt=""
						/>
						{active === "BATCH" && <div className={style.arrow}></div>}
					</div>
				)}
				{type === "edit" && active !== "FLOW" ? null : (
					<div
						className={classNames({
							[style.switchItem]: true,
							[style.activeSwitchItem]: active === "FLOW",
						})}
					>
						<img
							onClick={() => setActive("FLOW")}
							className={classNames({
								[style.itemImg]: true,
								[style.activeImg]: active === "FLOW",
							})}
							src={bottomImg || flowImg}
							alt=""
						/>
						{active === "FLOW" && <div className={style.arrow}></div>}
					</div>
				)}
			</div>
		</div>
	);
};

export default SwitchBatchFolw;
