/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-05 14:00:37
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-12-13 14:21:36
 * @FilePath: /bkunyun/src/api/workbench_api.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import request from "@/utils/axios/service";
import Api from "./api_manager";
import { IGetOperatorListParams } from "./workbenchInterface";

function current() {
    return request({
        url: Api.API_USER_FETCH,
        method: "get",
    });
}

function menu() {
    return request({
        url: "/accounts/menu-mock",
        method: "get",
    });
}

type workflowspecTemplateParams = {
    projectId: string;
    title?: string;
    page: number;
    size: number;
};

// 查询项目下工作流模板列表
const getWorkbenchTemplate = (params: workflowspecTemplateParams) => {
    return request({
        url: Api.API_WORKBENCH_TEMPLATE_LIST,
        method: "get",
        params,
    });
};

type workflowspecDeleteTemplateParams = {
    projectId: string;
    workflowSpecId: string;
};

// 项目管理员-删除工作流模板
const deleteWorkbenchTemplate = (params: workflowspecDeleteTemplateParams) => {
    return request({
        url: Api.API_WORKBENCH_DELETE_TEMPLATE,
        method: "delete",
        params,
    });
};

type workflowspecGetAddTemplateParams = {
    projectId?: string;
    productId: string;
    keyword?: string;
    creator?: string;
};

// 项目管理员-添加工作流模板-模板列表
const getAddWorkbenchTemplate = (params: workflowspecGetAddTemplateParams) => {
    return request({
        url: Api.API_WORKBENCH_ADD_TEMPLATE_LIST,
        method: "get",
        params,
    });
};


type workflowspecAddTemplateParams = {
    projectId: string;
    workflowSpecIds: string[];
};

// 项目管理员-添加工作流模板-提交
const addWorkbenchTemplate = (params: workflowspecAddTemplateParams) => {
    return request({
        url: Api.API_WORKBENCH_ADD_TEMPLATE,
        method: "post",
        data: params,
    });
};


type workflowJobListParams = {
    projectId: string;
    name?: string;
    state?: string;
    page?: number;
    size?: number;
};

// 查询项目下工作流模板列表
const getWorkflowJobList = (params: workflowJobListParams) => {
    return request({
        url: Api.API_WORKBENCH_WORKFLOWJOB_LIST,
        method: "get",
        params,
    });
};


type workflowJobDelParams = {
    id: string
};

// 项目管理员-删除工作流模板
const deleteWorkflowJob = (params: workflowJobDelParams) => {
    return request({
        url: Api.API_WORKBENCH_DEL_WORKFLOWJOB + params.id,
        method: "delete",
    });
};



type workflowJobCancelParams = {
    jobid: string
};

// 取消工作流
const cancelWorkflowJob = (params: workflowJobCancelParams) => {
    return request({
        url: Api.API_WORKBENCH_CANCEL_WORKFLOWJOB,
        method: "delete",
        params,
    });
};

// 获取算子列表数据
const fetchOperatorList = (params: IGetOperatorListParams) => {
    return request({
        url: Api.API_OPERATOR_LIST,
        method: "get",
        params,
    });
};


// 保存用户自定义工作流模板
const saveUserSpec = (params: any) => {
    return request({
        url: Api.API_SAVE_USERSPEC,
        method: "post",
        data: params,
    });
};

export {
    current,
    menu,
    getWorkbenchTemplate,
    deleteWorkbenchTemplate,
    getAddWorkbenchTemplate,
    addWorkbenchTemplate,
    getWorkflowJobList,
    deleteWorkflowJob,
    cancelWorkflowJob,
    fetchOperatorList,
    saveUserSpec
};
