// 局部loading组件

// 使用方法1  用一个div包裹children，在children上加一个蒙层和loading
// <MyCircularProgress loading={loading}>children</MyCircularProgress>

// 使用方法2  挂载在目标块下，目标块最少要添加一个position: relative; 或者absolute
// <div style={{ position: "relative", }} >
//   <MyCircularProgress loading={loading}/>
// </div>
import CircularProgress from "@mui/material/CircularProgress";

type IMyCircularProgressProps = {
	loading: boolean; // 是否处于loading状态
	children?: React.ReactNode; // 包裹的子元素
	minHeight?: string;
	maxHeight?: string;
	zIndex?: number;
	isBackground?: boolean;
};

const MyCircularProgress = (props: IMyCircularProgressProps) => {
	const {
		loading,
		minHeight = "none",
		maxHeight = "100vh",
		zIndex = "100",
		children,
		isBackground = true
	} = props;
	if (loading) {
		if (children) {
			return (
				<div
					style={{
						position: "relative",
					}}
				>
					<div
						style={{
							width: "100%",
							height: "100%",
							position: "absolute",
							top: 0,
							opacity: 0.6,
							background: isBackground ? '#FFF': 'none',
							zIndex: zIndex,
						}}
					></div>
					<div
						style={{
							width: "100%",
							height: "100%",
							display: "flex",
							justifyContent: "center",
							alignItems: "center",
							position: "absolute",
							top: 0,
							zIndex: zIndex,
							maxHeight: maxHeight,
						}}
					>
						<CircularProgress></CircularProgress>
					</div>
					{children}
				</div>
			);
		} else {
			return (
				<div
					style={{
						width: "100%",
						height: "100%",
						position: "absolute",
						top: 0,
						zIndex: zIndex,
						minHeight: minHeight,
					}}
				>
					<div
						style={{
							width: "100%",
							height: "100%",
							position: "absolute",
							top: 0,
							opacity: 0.6,
							background: "#fff",
						}}
					></div>
					<div
						style={{
							width: "100%",
							height: "100%",
							display: "flex",
							justifyContent: "center",
							alignItems: "center",
							maxHeight: maxHeight,
						}}
					>
						<CircularProgress></CircularProgress>
					</div>
				</div>
			);
		}
	} else {
		if (children) {
			return <>{children}</>;
		} else {
			return null;
		}
	}
};

export default MyCircularProgress;
