/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-12-13 16:12:00
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useMemo } from "react";
import { useLocation } from "react-router-dom";

import { Box } from "@mui/system";
import { useStores } from "@/store/index";
import NoProject from "@/components/BusinessComponents/NoProject";
import { observer } from "mobx-react-lite";
import ProjectMembers from "./ProjectMembers";
import BaseInfo from "./BaseInfo";
import Tabs from "@/components/mui/MyTabs";
import usePass from "@/hooks/usePass";

const ProjectSetting = observer(() => {
	const { currentProjectStore } = useStores();
	const isPass = usePass();
	const location: any = useLocation();
	const tabList = useMemo(() => {
		return [
			{
				label: "项目成员",
				value: "projectMember",
				hide: !isPass("PROJECT_SETTING_MEMBER"),
				component: <ProjectMembers />,
			},
			{
				label: "基础信息",
				value: "baseInfo",
				component: <BaseInfo />,
			},
		];
	}, [isPass]);

	if (currentProjectStore.currentProjectInfo.name) {
		return (
			<div style={{ padding: "22px 24px" }}>
				<div
					style={{ display: "flex", alignItems: "center", marginBottom: "3px" }}
				>
					<span
						style={{
							fontSize: "18px",
							lineHeight: "26px",
							fontWeight: "600",
							color: "#1E2633",
						}}
					>
						项目设置
					</span>
				</div>
				<Box sx={{ width: "100%", typography: "body1" }}>
					<Tabs
						tabList={tabList}
						defaultValue={location?.state?.type || undefined}
					/>
				</Box>
			</div>
		);
	} else {
		return <NoProject />;
	}
});

export default memo(ProjectSetting);
