/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-20 17:36:14
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2023-02-15 17:23:07
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/components/AddOperator/utils.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import { IOperatorAddFormData } from "../../interface";


type IBuildType = "ENVIRONMENT" | "OPERATOR";


	// 校验新版本号是否大于旧版本号
	const checkNewOldVersion = (version: string, oldVersion: string): string => {
		let versionArr: any[] = version.split(".");
		let oldVersionArr: any[] = oldVersion.split(".");
		versionArr = versionArr.map((item) => Number(item));
		oldVersionArr = oldVersionArr.map((item) => Number(item));

		if (versionArr[0] < oldVersionArr[0]) {
			return "新版本号必须大于老版本号且大于等于1.0.0"
		} else if (versionArr[0] === oldVersionArr[0]) {
			if (versionArr[1] < oldVersionArr[1]) {
				return "新版本号必须大于老版本号且大于等于1.0.0"
			} else if (versionArr[1] === oldVersionArr[1]) {
				if (versionArr[2] <= oldVersionArr[2]) {
					return "新版本号必须大于老版本号且大于等于1.0.0"
				}
			}
		}
		return '';
	}


export const checkFormData = (formData: IOperatorAddFormData, taskType: IBuildType, oldVersion: string)=>{
  const reg = new RegExp("^[A-Za-z0-9\u4e00-\u9fa5]{1,15}$");

  const result:IOperatorAddFormData = {}

  const versionErr = checkNewOldVersion(formData?.version || '', oldVersion )

  if(!formData?.title){
    result.title = '请输入算子名称'
  }
  if(!reg.test(formData?.title || '')){
    result.title = '格式不正确,仅限大小写字母、数字、中文'
  }
  if(!/^[1-9]\d?(\.(0|[1-9]\d?)){2}$/.test(formData?.version || '')){
    result.version = '格式不正确,必须为X.Y.Z格式,且XYZ必须为0~99的正整数'
  }

  if(versionErr) {
    result.version = versionErr
  }
  if(!formData?.version){
    result.version = '请输入算子版本'
  }
  if(!formData?.productId){
    result.productId = '请选择所属产品'
  }
  if(taskType ==='ENVIRONMENT' && !formData?.envId){
    result.envId = '请选择应用环境'
  }
  
  return result
}

/** 编辑算子版本默认加0.0.1 */
export const editDefaultVersion = (version: string)=>{
  let arr = version.split(".");
  if (arr.length === 3) {
    if (Number(arr[2]) < 99) {
      arr[2] = String(Number(arr[2]) + 1);
    } else {
      arr[2] = "0";
      if (Number(arr[1]) < 99) {
        arr[1] = String(Number(arr[1]) + 1);
      } else {
        arr[1] = "0";
        arr[0] = String(Number(arr[0]) + 1);
      }
    }
  }
  return arr.join(".")
}


/** 参数配置校验 */
export const checkParamsConfig = (val: string) => {
  let result: any = []
  try{
    const value = JSON.parse(val)
    value?.length && value.forEach((item: any)=>{
      const nameReg = new RegExp("^[A-Za-z][A-Za-z0-9_]{1,14}$");
      const titleReg = new RegExp("^[A-Za-z0-9\u4e00-\u9fa5]{1,15}$");
      if( !nameReg.test(item?.name) ){
        result.push(`name: ${item?.name}`)
      }
      if( !titleReg.test(item?.title) ){
        result.push(`title: ${item?.title}`)
      }
      if( item?.description > 300 ){
        result.push(`description: ${item?.description}`)
      }
      if( !['STRING','FILE','DATASET','INT','FLOAT','DOUBLE','BOOLEAN','ARRAY_STRING','ARRAY_FILE','ARRAY_DATASET','ARRAY_INT','ARRAY_FLOAT','ARRAY_DOUBLE','ARRAY_BOOLEAN','TEXT','JSON'].includes(item?.classType )){
        result.push(`classType: ${item?.classType}`)
      }
      if(!['true','false'].includes(String(item?.required)) ) {
        result.push(`required: ${item?.required}`)
      }
      if( !['PATH','DATASET','FILE','INPUT','SELECT','MULTIPLESELECT','RADIO','CHECKBOX'].includes(item?.domType )){
        result.push(`domType: ${item?.domType}`)
      }
      if( !['in', 'out', 'basis', 'senior', 'hardware'].includes(item?.parameterGroup )){
        result.push(`parameterGroup: ${item?.parameterGroup}`)
      }
    })
  } catch(error){
    console.log(error)
  }
  return result
}

export const initCode =  [{
    "name" : "paramName",
   "classType" : "INT",
    "required" : false,
    "defaultValue" : 10000,
    "description" : "",
    "hidden" : true,
    "title" : "这里填参数标题",
    "order" : 0,
    "parameterGroup": "in",
    "domType" : "INPUT",
    "choices" : [ 
                    {
                        "label" : "是",
                        "value" : "true"
                    }, 
                    {
                      "label": "否",
                      "value": "false"
                    }
                ],
     "validators" : [ 
                      {
                          "regex" : "^.*\\.(pdb|PDB|pdbqt|PDBQT)$",
                          "message" : "请输入PDB或PDBQT文件"
                      }
                    ]
}]


export const text = `{
  // 参数名; 必填, 在15字符以内，仅限大小写字母、数字、"_",且只能以大小写字母开头
  "name" : "timeout",
  // 参数类型; 必填, 可选值有 STRING：字符串、FILE：文件、DATASET：数据集、INT：整型、FLOAT：单精度浮点型、DOUBLE：多精度浮点型、BOOLEAN：布尔值、ARRAY_STRING：字符串数组、ARRAY_FILE：文件数组、ARRAY_DATASET：数据集数组、ARRAY_INT：整型数组、ARRAY_FLOAT：单精度浮点型数组、ARRAY_DOUBLE：多精度浮点型数组、ARRAY_BOOLEAN：布尔值数组
  "classType" : "INT",
  // 是否必填; 在使用该算子时是否必须输入改参数的值
  "required" : false,
  // 默认值
  "defaultValue" : 10000,
  // 参数描述; 在300字符以内
  "description" : "",
  // 是否隐藏; 必填, 隐藏就在页面不显示该参数 必填
  "hidden" : true,
  // 页面展示的参数的名称; 必填,  在15字符以内，仅限大小写字母、数字、中文
  "title" : "",
  // 参数展示的顺序优先级
  "order" : 0,
  // 参数分组; 必填,  可选值有 in： 输入、out：输出、basis：基础、senior：高级
  "parameterGroup": "in",
  // 前端填值的方式; 必填, 可选值有 PATH：路径选择器、DATASET：数据集选择器、FILE：文件选择器、INPUT：输入框、SELECT：下拉框、MULTIPLESELECT：多选下拉框、RADIO：单选按钮、CHECKBOX：多选按钮
  "domType" : "INPUT",
  // 选项; 当domType为SELECT、MULTIPLESELECT、RADIO、CHECKBOX时生效。以对象数组的形式保存
  "choices" : [ 
    {
      // 在前端展示的值
      "label" : "是",
      //选中时传递服务使用的值
      "value" : "true"
    }, 
  ],
  //用于校验输入值; 以对象数组的形式保存
  "validators" :  [ 
    {
      //正则表达式
      "regex" : "^.*\\.(pdb|PDB|pdbqt|PDBQT)$",
      //不符合正则时的报错信息
      "message" : "请输入PDB或PDBQT文件"
    }
  ]
}`