// 应用环境
import { useState } from "react";
import style from "./index.module.css";
import SearchInput from "@/components/BusinessComponents/SearchInput";
import MySelect from "@/components/mui/MySelect";
import MyButton from "@/components/mui/MyButton";
import AddEnvironment from "./AddEnvironment";

const UserResourcesEnvironment = () => {
	const [addOpen, setAddopen] = useState(true);
	return (
		<div className={style.environment}>
			<div className={style.top}>
				<div className={style.topLeft}>
					<SearchInput sx={{ width: 340, marginRight: "16px" }}></SearchInput>
					<MySelect
						options={[
							{
								label: "环境类型",
								value: "a",
							},
						]}
						sx={{ width: "150px", height: "32px" }}
					></MySelect>
				</div>
				<div className={style.topRight}>
					<MyButton
						text="构建应用环境"
						img={
							<span
								style={{ fontSize: "14px", marginRight: "8px" }}
								className="iconfont icon-dianzan"
							></span>
						}
					></MyButton>
				</div>
			</div>
			UserResourcesEnvironment
			{addOpen && <AddEnvironment></AddEnvironment>}
		</div>
	);
};

export default UserResourcesEnvironment;
