import request from "@/utils/axios/service";
import Api from "./api_manager";

function current() {
  return request({
    url: Api.API_USER_FETCH,
    method: "get",
  });
}

function menu() {
  return request({
    url: "/accounts/menu-mock",
    method: "get",
  });
}

type projectListParams = {
  product: string;
  name?: string;
};

// 查询当前用户可以看到的项目列表
const product = (params: projectListParams) => {
  return request({
    url: Api.API_PROJECT_LIST,
    method: "get",
    params,
  });
};

type addProjectParams = {
  product: string;
  name: string;
  zoneId: string;
  desc?: string;
};
// 新增项目
const addProject = (params: addProjectParams) => {
  return request({
    url: Api.API_PROJECT_ADD,
    method: "post",
    data: params,
  });
};

// 获取计算区列表
const hpczone = () => {
  return request({
    url: Api.API_CPCE_HPCZONE,
    method: "get",
  });
};

type getProjectParams = {
  id: string;
};

// 获取项目信息
const getProject = (params: getProjectParams) => {
  return request({
    url: Api.API_PROJECT_GET,
    method: "get",
    params,
  });
};

// 修改项目信息
const updateProject = (params: addProjectParams) => {
  return request({
    url: Api.API_PROJECT_UPDATE,
    method: "put",
    data: params,
  });
};

type deleteProjectParams = {
  id: string;
};

// 删除项目
const deleteProject = (params: deleteProjectParams) => {
  return request({
    url: Api.API_PROJECT_DELETE,
    method: "delete",
    params,
  });
};

type getDataFileTokenParams = {
  id: string;
};
// 获取项目目录的filetoken
const getDataFileToken = (params: getDataFileTokenParams) => {
  return request({
    url: Api.API_DATA_FILETOKEN,
    method: "get",
    params,
  });
};

type getDataFindParams = {
  projectId: string;
  path: string;
};

// 查询某路径下数据集
const getDataFind = (params: getDataFindParams) => {
  return request({
    url: Api.API_DATA_FIND,
    method: "get",
    params,
  });
};

type getDataFileSearchParams = {
  projectId: string;
  name: string;
  path?: string;
};

// 搜索项目中某路径下的数据集
const getDataFileSearch = (params: getDataFileSearchParams) => {
  return request({
    url: Api.API_DATA_SEARCH,
    method: "get",
    params,
  });
};

type getDataFileMoveParams = {
  projectId: string;
  names: string;
  spath?: string; // 原路径
  dpath?: string; // 目标路径
};

// Content-Type	application/x-www-form-urlencoded
// 移动到
const getDataFileMove = (params: getDataFileMoveParams) => {
  return request({
    url: Api.API_DATA_MOVE,
    method: "put",
    data: params,
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
    },
  });
};

type getDataFileDelParams = {
  projectId: string;
  names: string;
  path?: string;
};

// Content-Type	application/x-www-form-urlencoded
// 删除项目中的数据集
const getDataFileDel = (params: getDataFileDelParams) => {
  return request({
    url: Api.API_DATA_DEL,
    method: "delete",
    params,
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
    },
  });
};

export {
  current,
  menu,
  product,
  hpczone,
  addProject,
  getProject,
  updateProject,
  deleteProject,
  getDataFileToken,
  getDataFind,
  getDataFileSearch,
  getDataFileMove,
  getDataFileDel,
};
