/*
 * @Author: 吴永生 15770852798@163.com
 * @Date: 2022-10-17 14:35:11
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-10-24 20:38:16
 * @FilePath: /bkunyun/src/views/ResourceCenter/UserResources/WorkflowOperator/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import styles from "./index.module.css";
import { IOperatorInfo, operatorType } from "../../interface";
import { observer } from "mobx-react";
import { useStores } from "@/store";
import { useMemo } from "react";
import MyMenu from "@/components/mui/MyMenu";
import { useNavigate } from "react-router-dom";

interface IProps {
	operatorInfo: IOperatorInfo;
	setPageType: (val: string) => void;
	setDetailsId: (val: string) => void;
}

const OperatorCard = observer((props: IProps) => {
	const navigate = useNavigate();
	const {
		operatorInfo: { title = "", type, version, productId, createdTime, id },
		setPageType,
		setDetailsId,
	} = props;
	/** 产品store */
	const { productListStore } = useStores();

	const productText = useMemo(() => {
		const result = productListStore.productList?.filter((item) => {
			return item.value === productId;
		});
		return result?.length ? result[0].label : "";
	}, [productListStore.productList, productId]);

	const onClickOperation = (val: string) => {
		if (val === "upgrade") {
			setPageType("edit");
			setDetailsId(id || "");
		}
	};

	const handleToSeeOperator = (item: any) => {
		navigate("/utility/resourceCenter/userResources/seeFloe", {
			state: { id: item.id },
		});
	};

	return (
		<div className={styles.itemBox} onClick={handleToSeeOperator}>
			<div className={styles.itemHeaderBox}>
				<div className={styles.startTitleBox}>{title?.slice(0, 1)}</div>
				<div style={{ flex: 1, marginLeft: 12 }}>
					<b className={styles.titleBox}>{title}</b>
					<span className={styles.operatorTypeBox}>
						{operatorType[type] || ""}
					</span>
				</div>
				<MyMenu
					value=""
					options={[{ label: "升级", value: "upgrade" }]}
					hasTriangle={false}
					setValue={onClickOperation}
					sx={{
						zIndex: 1601,
					}}
				>
					<span className={styles.operationBox}>大大</span>
				</MyMenu>
			</div>
			<div className={styles.itemContentBox}>
				<p className={styles.infoBox}>
					所属产品：<span>{productText}</span>
				</p>
				<p className={styles.infoBox}>
					算子版本：<span>{`V${version}`}</span>
				</p>
				<p className={styles.infoBox}>
					创建时间：<span>{createdTime}</span>
				</p>
			</div>
		</div>
	);
});

export default OperatorCard;
