import noFile from "@/assets/project/noFile.svg";
import style from "./index.module.css";

type INoDataProps = {
	text?: string;
	noDataBoxStyle?: any;
};

const NoData = (props: INoDataProps) => {
	return (
		<div className={style.noDataBox} style={{ ...props.noDataBoxStyle }}>
			<img className={style.noDataImg} src={noFile} alt="" />
			<span className={style.noDataText}>
				{props.text ? props.text : "暂无数据"}
			</span>
		</div>
	);
};

export default NoData;
