/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2021-12-04 15:46:25
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-21 18:00:58
 * @FilePath: /lionet-slb-pc/src/components/SearchView/components/Collapse.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import InputLabel from "@mui/material/InputLabel";
import MenuItem from "@mui/material/MenuItem";
import FormControl from "@mui/material/FormControl";
import FormHelperText from "@mui/material/FormHelperText";
import Select, { SelectChangeEvent, SelectProps } from "@mui/material/Select";
import { createTheme, ThemeProvider } from "@mui/material";
import selectActive from "@/assets/project/selectActive.svg";

export interface IOption {
	label: string;
	value: string;
	disabled?: boolean;
}

export const optionsTransform = (
	arr: Array<any>,
	labelKey: string = "label",
	valueKey: string = "value",
	disabledKey: string = "disabled"
): Array<IOption> => {
	return arr.map((item: any) => {
		return {
			label: item[labelKey],
			value: item[valueKey],
			disabled: item[disabledKey],
		};
	});
};

interface IProps
	extends Omit<SelectProps, "value" | "options" | "onChange" | "title"> {
	value?: string;
	options: IOption[];
	onChange?: (val: string) => void;
	/** 类型变种 */
	variant?: "standard" | "outlined" | "filled";
	/** title */
	title?: string;
	/** 是否显示title */
	isTitle?: boolean;
	/** 是否显示提示文案 */
	error?: boolean;
	/** 提示文案 */
	helpertext?: string;
}
export default function MySelect(props: IProps) {
	const {
		value,
		options,
		title,
		isTitle = false,
		variant = "outlined",
		multiple = false,
		onChange,
		fullWidth,
		error = false,
		helpertext,
		...other
	} = props;

	const theme = createTheme({
		components: {
			MuiInputBase: {
				styleOverrides: {
					root: {
						height: "36px",
						"& .Mui-disabled": {
							background: "rgba(247, 248, 250, 1)",
							cursor: "not-allowed",
							"& .MuiOutlinedInput-notchedOutline": {
								borderColor: "#DDE1E6",
							},
						},
					},
					input: {
						fontSize: "14px",
						"&.Mui-disabled": {
							background: "rgba(247, 248, 250, 1)",
							cursor: "not-allowed",
						},
						img: {
							display: "none",
						},
					},
				},
			},
			MuiList: {
				styleOverrides: {
					root: {
						"& .MuiButtonBase-root": {
							"&.Mui-selected": {
								backgroundColor: "#fff",
								color: "#1370FF",
							},
						},
					},
				},
			},

			MuiMenuItem: {
				styleOverrides: {
					root: {
						paddingRight: "46px",
						fontSize: "14px",
						lineHeight: "24px",
						":hover": {
							backgroundColor: "#F0F2F5 ",
							color: "#1E2633",
						},
					},
				},
			},

			MuiOutlinedInput: {
				styleOverrides: {
					root: {
						"&.Mui-focused .MuiOutlinedInput-notchedOutline": {
							borderWidth: "1px",
						},
						"& .MuiOutlinedInput-notchedOutline": {
							borderColor: "#DDE1E6",
						},
						"&.Mui-disabled": {
							background: "rgba(247, 248, 250, 1)",
							cursor: "not-allowed",
							"& .MuiOutlinedInput-notchedOutline": {
								borderColor: "#DDE1E6",
							},
						},
						":hover": {
							"& .MuiOutlinedInput-notchedOutline": {
								borderColor: "#1370ff",
							},
							"&.Mui-disabled": {
								background: "rgba(247, 248, 250, 1)",
								cursor: "not-allowed",
								"& .MuiOutlinedInput-notchedOutline": {
									borderColor: "#DDE1E6",
								},
							},
						},
					},
				},
			},

			MuiInputLabel: {
				styleOverrides: {
					root: {
						fontSize: "14px",
						// 下拉框未选择时的label定位
						top: "-9px",
					},
					shrink: {
						// 下拉框已经选择时的label定位
						top: 0,
					},
				},
			},

			MuiSelect: {
				styleOverrides: {
					select: {
						padding: "6.5px 14px",
						fontSize: "14px",
					},
				},
			},

			MuiPaper: {
				styleOverrides: {
					root: {
						boxShadow: "0px 3px 10px 0px rgba(0,24,57,0.14)",
					},
				},
			},

			// MuiFormControl: {
			// 	styleOverrides: {
			// 		root: {
			// 			width: fullWidth ? "100%" : "auto",
			// 		},
			// 	},
			// },
		},
	});

	const handleChange = (e: SelectChangeEvent<unknown>) => {
		onChange && onChange(e.target.value as string);
	};

	return (
		<ThemeProvider theme={theme}>
			<FormControl fullWidth={fullWidth} variant={variant} error={error}>
				{isTitle ? (
					<InputLabel id="demo-simple-select-label">
						{title || "请选择"}
					</InputLabel>
				) : null}
				<Select
					labelId="demo-simple-select-label"
					id="demo-simple-select"
					label={title || ""}
					size="small"
					multiple={multiple}
					{...other}
					value={value || ""}
					onChange={handleChange}
				>
					{options.length
						? options?.map((item: IOption, index) => {
								return (
									<MenuItem
										value={item.value}
										disabled={item?.disabled}
										key={index}
									>
										{item.label}
										{value === item.value && (
											<img
												style={{
													width: "16px",
													height: "16px",
													position: "absolute",
													top: "10px",
													right: "12px",
												}}
												src={selectActive}
												alt=""
											/>
										)}
									</MenuItem>
								);
						  })
						: null}
				</Select>
				{helpertext && error && <FormHelperText>{helpertext}</FormHelperText>}
			</FormControl>
		</ThemeProvider>
	);
}
