import styles from "../index.module.css";
import { ITaskInfo } from "../../ProjectSubmitWork/interface";
import jobSue from "@/assets/project/jobSue.svg";
import jobStop from "@/assets/project/jobStop.svg";
import jobRun from "@/assets/project/jobRun.svg";
import jobFail from "@/assets/project/jobFail.svg";
import taskResultsFileIcon from "@/assets/project/taskResultsFileIcon.svg";
import taskResultsDatasetIcon from "@/assets/project/taskResultsDatasetIcon.svg";
import { IState } from "../../ProjectSubmitWork/interface";
import classNames from "classnames";

type ITaskInfoProps = {
	workFlowJobInfo: ITaskInfo;
	randerOutputs1: Array<any>;
	handleDownLoadOutput: any;
	handleShowPopper: any;
	setGoToProjectDataPath: any;
	setShowLogView: any;
	state: IState | undefined;
	name: any;
};

const stateMap = {
	SUBMITTED: "正在启动",
	RUNNING: "正在运行",
	ABORTED: "运行终止",
	FAILED: "运行失败",
	SUCCEEDED: "运行成功",
};

const TaskInfo = (props: ITaskInfoProps) => {
	const {
		workFlowJobInfo,
		randerOutputs1,
		handleDownLoadOutput,
		handleShowPopper,
		setGoToProjectDataPath,
		setShowLogView,
		state,
		name,
	} = props;

	return (
		<div className={styles.taskInfo}>
			<div className={styles.title}>
				任务结果
				<span className={styles.taskResultsNum}>{randerOutputs1.length}</span>
			</div>
			{workFlowJobInfo?.outputs &&
				Object.keys(workFlowJobInfo?.outputs).length > 0 && (
					<div className={styles.taskResults}>
						{randerOutputs1.map((item, index) => {
							return (
								<div key={index} className={styles.outputLi}>
									<div className={styles.outputLiLeft}>
										<img
											className={classNames({
												[styles.outputLiLeftImg]: true,
												[styles.outputLiLeftImgBoxShadow2]:
													item.type === "file",
											})}
											src={
												item.type === "file"
													? taskResultsFileIcon
													: taskResultsDatasetIcon
											}
											alt=""
										/>
										<div className={styles.outputLiLeftContent}>
											<div className={styles.outputItemName}>{item.name}</div>
											<div className={styles.outputLiSize}>{item.size}</div>
										</div>
									</div>
									<div
										onClick={(e: any) => {
											handleDownLoadOutput(item);
										}}
										className={classNames({
											[styles.outputLiRight]: true,
											[styles.seeDataset]: item.type !== "file",
											[styles.downloadFile]: item.type === "file",
										})}
									></div>
								</div>
							);
						})}
					</div>
				)}
			{(!workFlowJobInfo?.outputs ||
				Object.keys(workFlowJobInfo?.outputs).length === 0) && (
				<div className={styles.notResults}>暂无结果文件</div>
			)}
			<div className={styles.title}>任务信息</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>任务名称</div>
				<div className={styles.taskInfoValue} title={name}>
					{name || "-"}
				</div>
			</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>任务ID</div>
				<div className={styles.taskInfoValue} title={workFlowJobInfo?.id}>
					{workFlowJobInfo?.id || "-"}
				</div>
			</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>输出路径</div>
				<div
					className={classNames({
						[styles.taskInfoValue]: true,
						[styles.taskInfoValueClick]: true,
					})}
					onClick={(e: any) => {
						handleShowPopper(
							e,
							"即将跳转至项目数据内该任务的输出路径，确认继续吗？",
							"bottom"
						);
						setGoToProjectDataPath(workFlowJobInfo?.outputPath as string);
					}}
				>
					{workFlowJobInfo?.outputPath || "-"}
				</div>
			</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>运行状态</div>
				<div className={styles.taskInfoValue}>
					{state === "SUCCEEDED" && (
						<img className={styles.taskInfoValueIcon} src={jobSue} alt="" />
					)}
					{["SUBMITTED", "RUNNING"].includes(state || "") && (
						<img className={styles.taskInfoValueIcon} src={jobRun} alt="" />
					)}
					{state === "ABORTED" && (
						<img className={styles.taskInfoValueIcon} src={jobStop} alt="" />
					)}
					{state === "FAILED" && (
						<img className={styles.taskInfoValueIcon} src={jobFail} alt="" />
					)}
					{state ? stateMap[state] : "-"}
				</div>
			</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>源模板</div>
				<div className={styles.taskInfoValue}>
					{workFlowJobInfo?.specTitle || "-"}
				</div>
			</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>源模板版本</div>
				<div className={styles.taskInfoValue}>
					{workFlowJobInfo?.specVersion || "-"}
				</div>
			</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>花费（元）</div>
				<div className={styles.taskInfoValue}>
					{workFlowJobInfo?.jobCost || "-"}
				</div>
			</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>创建人</div>
				<div className={styles.taskInfoValue}>
					{workFlowJobInfo?.creator || "-"}
				</div>
			</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>创建时间</div>
				<div className={styles.taskInfoValue}>
					{workFlowJobInfo?.createTime || "-"}
				</div>
			</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>运行时间</div>
				<div className={styles.taskInfoValue}>
					{workFlowJobInfo?.costTime || "-"}
				</div>
			</div>
			<div className={styles.taskInfoLi}>
				<div className={styles.taskInfoParams}>日志文件</div>
				<div className={styles.taskInfoValue}>
					{workFlowJobInfo?.logPath && (
						<>
							<span
								className={styles.taskInfoDownload}
								onClick={() => setShowLogView(true)}
							>
								查看
							</span>
						</>
					)}
					{!workFlowJobInfo?.logPath && "-"}
				</div>
			</div>
		</div>
	);
};

export default TaskInfo;
