// 按钮样式的单选组
import classnames from "classnames";
import style from "./index.module.css";

type radioOption = {
  value: string;
  label: string;
};

type IRadioGroupOfButtonStyleProps = {
  radioOptions: Array<radioOption>;
  value: string;
  handleRadio: any;
};

const RadioGroupOfButtonStyle = (props: IRadioGroupOfButtonStyleProps) => {
  const { radioOptions, value, handleRadio } = props;

  return (
    <div className={style.RadiosBox}>
      {radioOptions.map((options) => {
        return (
          <div
            key={options.value}
            className={classnames({
              [style.radio]: true,
              [style.radioActive]: value === options.value,
            })}
            onClick={() => handleRadio(options.value)}
          >
            {options.label}
          </div>
        );
      })}
    </div>
  );
};

export default RadioGroupOfButtonStyle;
