import MyDialog from "../mui/Dialog";
import { useStores } from "@/store";
import { observer } from "mobx-react-lite";
import { toJS } from "mobx";
import { useEffect, useState } from "react";
import CloudEController from "@/api/fileserver/CloudEController";
import MyTreeView from "@/components/mui/MyTreeView";
import classNames from "classnames";
import bigFolderIcon from "@/assets/project/bigFolderIcon.svg";
import folderIcon from "@/assets/project/folderIcon.svg";
import dataSetIcon from "@/assets/project/dataSetIcon.svg";
import fileIcon from "@/assets/project/fileIcon.svg";
import useMyRequest from "@/hooks/useMyRequest";
import { getDataFind } from "@/api/project_api";
import style from "./index.module.css";
import _ from "lodash";

type FileSelectProps = {
  open: boolean;
  onConfirm: any;
  onClose: any;
  type?: "file" | "dataset" | "path";
};

const FileSelect = observer((props: FileSelectProps) => {
  const { onConfirm, type = "path" } = props;
  // const { onConfirm, type = "dataset" } = props;
  const { currentProjectStore } = useStores();
  const projectId = toJS(currentProjectStore.currentProjectInfo.id);
  const fileToken = toJS(currentProjectStore.currentProjectInfo.filetoken);
  const [treeData, setTreeData] = useState<Array<any>>([]);
  const [rootActive, setRootActive] = useState(true);
  const [newPath, setNewPath] = useState("/");

  // 获取某路径下的数据集
  const { run: getDataFindRun } = useMyRequest(getDataFind, {
    onSuccess: (res: any) => {
      const dataSetList = res.data.map((item: any) => {
        return {
          ...item,
          type: "dataset",
          dir: `/${item.path}`,
          subdirs: "",
        };
      });
      let treeDataArr = _.cloneDeep(treeData);
      if (newPath === "/") {
        treeDataArr = _.uniqWith([...treeDataArr, ...dataSetList], _.isEqual);
        setTreeData(treeDataArr);
      } else {
        let pathArr: Array<any> = newPath.split("/");
        pathArr.shift();
        let reduceResult = pathArr.reduce((result, path) => {
          if (Array.isArray(result)) {
            result.forEach((item: any, index: number) => {
              if (item.name === path) {
                result = result[index];
              }
            });
          } else if (Array.isArray(result.subdirs)) {
            result.subdirs.forEach((item: any, index: number) => {
              if (item.name === path) {
                result = result.subdirs[index];
              }
            });
          } else {
            result = result.subdirs;
          }

          return result;
        }, treeDataArr);
        if (Array.isArray(reduceResult.subdirs)) {
          reduceResult.subdirs = _.uniqWith(
            [...reduceResult.subdirs, ...dataSetList],
            _.isEqual
          );
        } else {
          reduceResult.subdirs = dataSetList;
        }
        treeDataArr = _.uniqWith(treeDataArr, _.isEqual);
        setTreeData(treeDataArr);
      }
    },
  });

  useEffect(() => {
    if (type === "dataset") {
      getDataFindRun({
        projectId: projectId as string,
        path: newPath === "/" ? "/" : `${newPath}/`,
      });
    }
  }, [newPath, getDataFindRun, projectId, type]);

  useEffect(() => {
    if (fileToken && projectId) {
      CloudEController.JobOutFileDirtree(
        "/",
        fileToken,
        projectId,
        false
      )?.then((res: any) => {
        if (Array.isArray(res.data)) {
          setTreeData(res.data);
        } else {
          setTreeData([]);
        }
        if (type === "dataset") {
          getDataFindRun({
            projectId: projectId as string,
            path: "/",
            // path: path === "/" ? "/" : `${path}/`,
          });
        }
      });
    }
  }, [projectId, fileToken, type, getDataFindRun]);

  // const renderLabel = (labelNmae: string) => {
  const renderLabel = (node: any) => {
    return (
      <span className={style.treeLabel}>
        {node.type === "directory" && (
          <img className={style.labelFolderIcon} src={folderIcon} alt="" />
        )}
        {node.type === "dataset" && (
          <img className={style.labelFolderIcon} src={dataSetIcon} alt="" />
        )}
        {node.type !== "directory" && node.type !== "dataset" && (
          <img className={style.labelFolderIcon} src={fileIcon} alt="" />
        )}
        <span className={style.treeLabelText}>{node.name}</span>
      </span>
    );
  };

  const handleRoot = () => {
    setNewPath("/");
    setRootActive(true);
  };

  const onNodeSelect = (a: any, b: any) => {
    setNewPath(b);
    setRootActive(false);
  };

  // 给路径去掉第一个'/'然后结尾加上文件名 方便后面直接使用
  const idFunc = (item: any) => {
    return `${item.dir.substr(1)}${item.name}`;
  };

  const fileSelectOnConfirm = () => {
    onConfirm(newPath);
  };

  return (
    <MyDialog
      open={props.open}
      onClose={props.onClose}
      onConfirm={fileSelectOnConfirm}
      title={type}
    >
      <div
        className={classNames({
          [style.rootTitle]: true,
          [style.rootTitleActive]: rootActive,
        })}
        onClick={handleRoot}
      >
        <img className={style.bigFolderIcon} src={bigFolderIcon} alt="" />
        ProjectData
      </div>
      <MyTreeView
        treeData={treeData}
        renderLabel={renderLabel}
        onNodeSelect={onNodeSelect}
        idFunc={idFunc}
        treeViewSx={{
          width: 400,
          overflow: "hidden",
        }}
      ></MyTreeView>
    </MyDialog>
  );
});

export default FileSelect;
