import { IOperatorItemProps } from "./interface";
import { OutlinedInput } from "@mui/material";
import SearchIcon from "@mui/icons-material/Search";

import styles from "./index.module.css";

/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-06 15:16:01
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-06 16:27:16
 * @FilePath: /bkunyun/src/views/WorkFlowEdit/components/OperatorList/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
const OperatorItem = (props: IOperatorItemProps) => {
	const { info } = props;
	return (
		<div className={styles.operatorItemBox}>
			<h2 className={styles.operatorItemTitle}>说什么呢啊</h2>
			<div className={styles.operatorItemText}>
				STU utility
				是一个R-packa标处理目标处理，目标处理目标处理标处理目标处理后期委屈好委屈农，博啊发布丢我被欺安度切换阿斯顿几切换，i的亲戚我好奇你eqeqeweqeqeeqeqeqeqeq。
			</div>
			<div className={styles.footerBx}>
				<span
					className={styles.labelBox}
					style={{
						background: true ? "#EBF3FF" : "#E3FAEC",
						color: true ? "#1370FF" : "#02AB83",
					}}
				>
					公共平台
				</span>
				<OutlinedInput
					onChange={(e: any) => {
						console.log(e.target.value);
					}}
					// value={templateName}
					placeholder="输入关键词搜索"
					size="small"
					sx={{ flex: 1, height: 32 }}
					endAdornment={<SearchIcon style={{ color: "#8A9099" }} />}
				/>
			</div>
		</div>
	);
};

const OperatorList = () => {
	const arr = [222, 3333, 339];
	return (
		<>
			{arr.map((item) => {
				return <OperatorItem key={item} info={item} />;
			})}
		</>
	);
};

export default OperatorList;
