/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-05 14:00:37
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-06 13:49:25
 * @FilePath: /bkunyun/src/components/mui/MyRadio.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import * as React from "react";
import Radio from "@mui/material/Radio";
import RadioGroup, { RadioGroupProps } from "@mui/material/RadioGroup";
import FormControlLabel from "@mui/material/FormControlLabel";
import FormControl from "@mui/material/FormControl";
import FormHelperText from "@mui/material/FormHelperText";
import { ThemeProvider, createTheme } from "@mui/material/styles";

interface IMyRadioProps extends RadioGroupProps {
	value: any;
	options: Array<ICheckBoxOption>;
	onChange: any;
	variant?: "standard" | "outlined" | "filled";
	error?: boolean;
	helperText?: string;
}

type ICheckBoxOption = {
	value: any;
	label?: string;
	disabled?: boolean;
};

// 如果后端给的options不是  value-label的字段可以用下面的方法转换
export const optionsTransform = (
	arr: Array<any>,
	labelKey: string = "label",
	valueKey: string = "value",
	disabledKey: string = "disabled"
): Array<ICheckBoxOption> => {
	return arr.map((item: any) => {
		return {
			value: item[valueKey],
			label: item[labelKey],
			disabled: item[disabledKey] || false,
		};
	});
};

const theme = createTheme({
	components: {
		MuiFormControlLabel: {
			styleOverrides: {
				label: {
					fontSize: "14px",
				},
			},
		},
		MuiSvgIcon: {
			styleOverrides: {
				root: {
					fontSize: "19px",
				},
			},
		},
	},
});

export default function MyRadio(props: IMyRadioProps) {
	const {
		value,
		options,
		onChange,
		error = false,
		helperText,
		variant,
	} = props;

	return (
		<ThemeProvider theme={theme}>
			<FormControl fullWidth variant={variant} error={error}>
				<RadioGroup
					{...props}
					row
					aria-labelledby="demo-row-radio-buttons-group-label"
					name="row-radio-buttons-group"
					value={value}
					onChange={onChange}
				>
					{options.map((option) => {
						return (
							<FormControlLabel
								key={option.value}
								value={option.value}
								control={<Radio sx={{ color: "rgba(209, 214, 222, 1)" }} />}
								label={option.label}
								disabled={option.disabled}
							/>
						);
					})}
				</RadioGroup>
				{helperText && error && <FormHelperText>{helperText}</FormHelperText>}
			</FormControl>
		</ThemeProvider>
	);
}
