import React, { useEffect, useState } from "react";
import { Outlet, useLocation, useNavigate } from "react-router-dom";
import { observer } from "mobx-react-lite";
import Avatar from "@mui/material/Avatar";
import { Box, Menu, MenuItem } from "@mui/material";
import classNames from "classnames";

import uploadIcon from "@/assets/img/uploadIcon.svg";
import triangle from "@/assets/project/triangle.svg";
import selectActive from "@/assets/project/selectActive.svg";
import globalText from "@/utils/globalText_CN";
import useIndex from "./useIndex";
import { useStores } from "@/store/index";
import logo from "@/assets/img/logo.svg";
import MyPopover from "@/components/mui/MyPopover";
import TranSferList from "./components/TransferList";
import { getProjectList } from "@/api/project_api";
import useMyRequest from "@/hooks/useMyRequest";
import { toJS } from "mobx";
import {
	setFileServerEndPointLocalStorage,
	getFiletokenAccordingToId,
} from "@/views/Project/project";

import style from "./index.module.css";

const ConsoleLayout = observer(() => {
	const { utilityAnchorEl, utilityOpen, handleUtilityClick, handleClose } =
		useIndex();

	const { currentProjectStore, fileListStore } = useStores();
	const { openFileList, setOpenFileList } = fileListStore;
	const productInfo = toJS(currentProjectStore.currentProductInfo);
	console.log(productInfo);
	const { run: runGetProjectList } = useMyRequest(getProjectList, {
		onSuccess: (res) => {
			let list = res.data;
			if (list.length === 0) {
				currentProjectStore.setProjectList([]);
				currentProjectStore.changeProject({});
				navigate(productInfo?.path as string);
			} else {
				currentProjectStore.setProjectList(list);
				currentProjectStore.changeProject(list[0]);
				setFileServerEndPointLocalStorage(list[0].zoneId);
				getFiletokenAccordingToId(list[0].id).then((res) => {
					list[0].filetoken = res;
					currentProjectStore.changeProject(list[0]);
				});
				navigate(productInfo?.path as string);
			}
		},
	});

	// 切换产品
	const getProduct = (item: any) => {
		currentProjectStore.changeProductInfo({
			id: item.id,
			name: item.name,
			path: item.path,
		});
		runGetProjectList({
			product: item.id,
		});
	};

	const navigate = useNavigate();
	const location = useLocation();
	const { permissionStore, menuStore } = useStores();

	// 不在产品页面下的时候清空
	useEffect(() => {
		console.log(location.pathname.slice(0, 8));
		if (location.pathname.slice(0, 8) !== "/product") {
			currentProjectStore.setProjectList([]);
			currentProjectStore.changeProject({});
			currentProjectStore.changeProductInfo({});
		}
	}, [location, currentProjectStore]);

	useEffect(() => {
		permissionStore.setSidebarRouters(location.pathname);
	}, [location, permissionStore]);

	return (
		<Box>
			<Box className={style.topApp}>
				<Box className={style.topLeftBox}>
					<img src={logo} alt="" className={style.logo} />
					{/* <MyButton
						text={globalText.console}
						variant={"text"}
						style={{ color: "#565C66" }}
						onClick={() => navigate("/home")}
					/> */}
					<div className={style.menuBox} onClick={() => navigate("/home")}>
						<div className={style.menuTitle}>{globalText.console}</div>
					</div>

					<div className={style.menuBox}>
						<div className={style.menuTitle}>
							<span>{globalText.product}</span>
							<img className={style.triangle} src={triangle} alt="" />
						</div>
						<div className={style.productList}>
							{menuStore.productList.map((item) => {
								return (
									<div
										key={item.path}
										className={classNames({
											[style.productLi]: true,
											[style.productLiActive]: productInfo.path === item.path,
										})}
										onClick={() => {
											getProduct(item);
											handleClose();
										}}
									>
										{item.name}
										{productInfo.path === item.path && (
											<img
												className={style.selectActive}
												src={selectActive}
												alt=""
											/>
										)}
									</div>
								);
							})}
						</div>
					</div>
				</Box>

				<Box className={style.topRightBox}>
					<MyPopover
						open={openFileList}
						changeOpen={(val) => setOpenFileList(val)}
						content={<TranSferList />}
						transformOrigin={{
							vertical: "top",
							horizontal: "right",
						}}
					>
						<div className={classNames(style.uploadIconBox)}>
							<img
								src={uploadIcon}
								alt=""
								style={{ verticalAlign: "middle" }}
							/>
						</div>
					</MyPopover>
					<Box className={style.topRightItem}>
						<Box
							sx={{ display: "flex", alignItems: "center" }}
							onClick={handleUtilityClick}
						>
							<Avatar
								sx={{
									bgcolor: "#1370FF",
									width: 28,
									height: 28,
									fontSize: "14px",
									cursor: "pointer",
								}}
							>
								H
							</Avatar>
							<img
								className={classNames({
									[style.topRightTriangle]: true,
									[style.topRightTriangleOpen]: Boolean(utilityOpen),
								})}
								src={triangle}
								alt=""
							/>
						</Box>

						<Menu
							id="utility-menu"
							anchorEl={utilityAnchorEl}
							open={utilityOpen}
							onClose={handleClose}
							MenuListProps={{
								"aria-labelledby": "utility-button",
							}}
						>
							{menuStore.utilityList.map((item) => {
								return (
									<MenuItem
										key={item.path}
										onClick={() => {
											navigate(item.path);
											handleClose();
										}}
									>
										{item.name}
									</MenuItem>
								);
							})}
						</Menu>
					</Box>
				</Box>
			</Box>
			<Box>
				<Outlet></Outlet>
			</Box>
		</Box>
	);
});

export default ConsoleLayout;
