/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-01 16:53:15
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-04 15:00:09
 * @FilePath: /bkunyun/src/components/Material.Ui/Button.jsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import React from "react";
import PropTypes from "prop-types";
import { makeStyles } from "@mui/styles";
import { Typography, Button, Menu, MenuItem } from "@mui/material";
const useStyles = makeStyles({
    root: { backgroundColor: "#136EFA", boxShadow: "none !important", color: "#ffffff", "&:hover": { backgroundColor: "#0055D9" } },
    containedSecondary: { backgroundColor: "#D62C1F", boxShadow: "none !important", "&:hover": { backgroundColor: "#D82C1F" } },
    outlined: { backgroundColor: '#FFFFFF', border: "1px solid #136EFA", boxShadow: "none !important", color: "#136EFA", "&:hover": { backgroundColor: "rgba(19, 110, 250, 0.1)" } },
    outlinedSecondary: { border: "1px solid #D62C1F", color: "#D62C1F", "&:hover": { border: "1px solid #D62C1F", backgroundColor: "rgba(214, 44, 31, 0.1)" } },
    label: { "& p": { fontSize: "13px" } },
    text: { backgroundColor: 'transparent', boxShadow: "none !important" },
    textPrimary: { color: "#136EFA", "&:hover": { backgroundColor: "#E8F1FF" } },
    textSecondary: { color: "#F44335", "&:hover": { backgroundColor: "rgba(244, 67, 53, 0.1)" } },
    sizeSmall: { "& p": { fontSize: "12px" } },
    sizeLarge: { "& p": { fontSize: "14px" } },
    menuItemRoot: {}
})

const ButtonComponent = (props) => {
    const classes = useStyles();
    const { img, select, selectCallBack, text, size, click, variant, color, disabled, disableElevation, disableFocusRipple, btnStyle = {}, fontSize = '' } = props;
    const [anchorEl, setAnchorEl] = React.useState(null);
    const defultClick = (event) => event && event.stoppropagation && event.stoppropagation()
    // 更多按钮 点击 弹出菜单
    const handleClick = (event) => setAnchorEl(event.currentTarget);
    // 关闭更多 menu 弹框
    const handleClose = () => setAnchorEl(null);
    // 选择更多按钮回调
    const handleCloseOption = (item, key) => {
        setAnchorEl(null);
        selectCallBack && selectCallBack(item, key)
    };
    return (
        <>
            <Button
                size={size || "medium"}
                variant={variant || "contained"}
                color={color || "primary"}
                disabled={disabled || false}
                disableElevation={disableElevation || false}
                disableFocusRipple={disableFocusRipple || false}
                classes={{
                    root: btnStyle.root || classes.root,
                    label: btnStyle.label || classes.label,
                    disabled: btnStyle.disabled || classes.disabled,
                    containedSecondary: btnStyle.containedSecondary || classes.containedSecondary,
                    outlined: btnStyle.outlined || classes.outlined,
                    outlinedSecondary: btnStyle.outlinedSecondary || classes.outlinedSecondary,
                    text: btnStyle.text || classes.text,
                    textPrimary: btnStyle.textPrimary || classes.textPrimary,
                    textSecondary: btnStyle.textSecondary || classes.textSecondary,
                    sizeSmall: btnStyle.sizeSmall || classes.sizeSmall,
                    sizeLarge: btnStyle.sizeLarge || classes.sizeLarge,
                }}
                style={{...props.style}}
                onClick={select ? handleClick : (click || defultClick)}
            >
                {img || ''}
                <Typography style={{ fontSize: fontSize }}>{text || ""}</Typography>
            </Button>
            <Menu
                id="simple-menu"
                anchorEl={anchorEl}
                keepMounted
                open={Boolean(anchorEl)}
                onClose={handleClose}
            >
                {
                    select && select.length > 0 && select.map((item, key) => {
                        return (
                            <MenuItem
                                key={key}
                                classes={{ root: classes.menuItemRoot }}
                                onClick={() => handleCloseOption(item, key)}>
                                {item.text || ""}
                            </MenuItem>
                        )
                    })
                }
            </Menu>
        </>
    )
}

ButtonComponent.propTypes = {
    size: PropTypes.oneOf(["large", "medium", "small"]),
    variant: PropTypes.oneOf(["contained", "outlined", "text"]),
    color: PropTypes.oneOf(["default", "inherit", "primary", "secondary"]),
    disabled: PropTypes.bool,
    disableElevation: PropTypes.bool,
    disableFocusRipple: PropTypes.bool,
    text: PropTypes.string,
    onClick: propTypes.func.isRequired,
};
export default ButtonComponent;