/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-01 16:53:15
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-05 16:39:01
 * @FilePath: /bkunyun/src/components/Material.Ui/Selectzone.jsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import React, { useState, useEffect } from "react";
import { makeStyles } from '@mui/styles';
import {
  Grid,
  ListItemText,
  Tooltip,
} from "@mui/material";
import icon from "@/assets/img/icon_about_grey.png";

const useStyles = makeStyles({
  popper:{fontSize:'12px'}
})
export default props => {
  const classesstyle=useStyles()
  const { item, classes , Icon , selected } = props;
  const [hover, sethover] = useState(false);
  const [select,setselect] = useState(false)
  useEffect(() => {
    setselect(selected?true:false)
  }, [selected]);
  const move = () => {
    !hover&&sethover(true)
  };
  const leave = () => {
    hover&&sethover(false)
  };
  return (
    <Grid
    onMouseEnter={move} 
    onMouseLeave ={leave}
    style={{display:'flex',alignItems:"center",justifyContent:'space-between',width:"100%",background:Icon === 'dashBoard' &&selected?'rgba(25, 28, 31, 1)':''}}
    > 
      {
        Icon === 'dashBoard' && <Grid style={{
          width:'2px',
          height:'34px',
          marginRight:'13px',
          background:selected?'linear-gradient(180deg, #F05A28 0%, #FBC40D 100%)':'transparent',
        }}></Grid>
      }
      <ListItemText
        primary={item.label}
        classes={{ primary: classes.primary }}
      />
     {Icon !=='dashBoard' &&item.description&&hover&&<Tooltip 
     arrow
     placement={'top'}
     classes={{
      tooltip: classesstyle.popper,
      }}
     title={item.description?item.description:""}><img src={item.src?item.src:icon} alt='' style={{ width: "16px",height:'16px', marginRight: "10px" ,marginLeft:'auto'}}/></Tooltip>}
     </Grid>
  );
};
