import React, { useState } from 'react';
import Button from '@material-ui/core/Button';
import Tooltip from '@material-ui/core/Tooltip';
import makeStyles from "@material-ui/styles/makeStyles";
const useStyles = makeStyles({
    tooltip: { backgroundColor: "#4D4D4D", borderRadius: "4px",padding:"8px 10px" ,fontSize:'12px'},
})

export default props => {
    const classes = useStyles()
    const { title, placement, children,tooltip } = props
    return (
        <Tooltip
            interactive={true}
            title={title}
            classes={{
                popper: classes.popper,
                tooltip:tooltip || classes.tooltip

            }}
            placement={placement || "top"}>
            {children}
        </Tooltip>
    )
}



// placement	'bottom-end'
// | 'bottom-start'
// | 'bottom'
// | 'left-end'
// | 'left-start'
// | 'left'
// | 'right-end'
// | 'right-start'
// | 'right'
// | 'top-end'
// | 'top-start'
// | 'top'

